/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.Saver;

public class SaverCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester,
EnvironmentHandler {
    private static final long serialVersionUID = -4874208115942078471L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Saver m_dsSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private Window m_parentWindow;
    private JDialog m_fileChooserFrame;
    private EnvironmentField m_dbaseURLText;
    private EnvironmentField m_userNameText;
    private JPasswordField m_passwordText;
    private EnvironmentField m_tableText;
    private JCheckBox m_truncateBox;
    private JCheckBox m_idBox;
    private JCheckBox m_tabBox;
    private EnvironmentField m_prefixText;
    private JCheckBox m_relativeFilePath;
    private JCheckBox m_relationNameForFilename;
    private Environment m_env = Environment.getSystemWide();
    private EnvironmentField m_directoryText;
    private FileEnvironmentField m_dbProps;
    private BeanCustomizer.ModifyListener m_modifyListener;

    public SaverCustomizer() {
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setApproveButtonText("Select directory");
        this.m_fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        File selectedFile = SaverCustomizer.this.m_fileChooser.getSelectedFile();
                        SaverCustomizer.this.m_directoryText.setText(selectedFile.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (SaverCustomizer.this.m_fileChooserFrame != null) {
                    SaverCustomizer.this.m_fileChooserFrame.dispose();
                }
            }
        });
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_SaverEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel db = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        db.setLayout(gbLayout);
        JLabel dbaseURLLab = new JLabel(" Database URL", 4);
        dbaseURLLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(dbaseURLLab, gbConstraints);
        db.add(dbaseURLLab);
        this.m_dbaseURLText = new EnvironmentField();
        this.m_dbaseURLText.setEnvironment(this.m_env);
        this.m_dbaseURLText.setText(((DatabaseConverter)((Object)this.m_dsSaver.getSaverTemplate())).getUrl());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 5.0;
        gbLayout.setConstraints(this.m_dbaseURLText, gbConstraints);
        db.add(this.m_dbaseURLText);
        JLabel userLab = new JLabel("Username", 4);
        userLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(userLab, gbConstraints);
        db.add(userLab);
        this.m_userNameText = new EnvironmentField();
        this.m_userNameText.setEnvironment(this.m_env);
        this.m_userNameText.setText(((DatabaseConverter)((Object)this.m_dsSaver.getSaverTemplate())).getUser());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_userNameText, gbConstraints);
        db.add(this.m_userNameText);
        JLabel passwordLab = new JLabel("Password ", 4);
        passwordLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(passwordLab, gbConstraints);
        db.add(passwordLab);
        this.m_passwordText = new JPasswordField();
        JPanel passwordHolder = new JPanel();
        passwordHolder.setLayout(new BorderLayout());
        passwordHolder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        passwordHolder.add((Component)this.m_passwordText, "Center");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(passwordHolder, gbConstraints);
        db.add(passwordHolder);
        JLabel tableLab = new JLabel("Table Name", 4);
        tableLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(tableLab, gbConstraints);
        db.add(tableLab);
        this.m_tableText = new EnvironmentField();
        this.m_tableText.setEnvironment(this.m_env);
        this.m_tableText.setEnabled(!((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getRelationForTableName());
        this.m_tableText.setText(((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getTableName());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_tableText, gbConstraints);
        db.add(this.m_tableText);
        JLabel tabLab = new JLabel("Use relation name", 4);
        tabLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(tabLab, gbConstraints);
        db.add(tabLab);
        this.m_tabBox = new JCheckBox();
        this.m_tabBox.setSelected(((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getRelationForTableName());
        this.m_tabBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaverCustomizer.this.m_tableText.setEnabled(!SaverCustomizer.this.m_tabBox.isSelected());
            }
        });
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_tabBox, gbConstraints);
        db.add(this.m_tabBox);
        JLabel truncLab = new JLabel("Truncate table", 4);
        truncLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 5;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(truncLab, gbConstraints);
        db.add(truncLab);
        this.m_truncateBox = new JCheckBox();
        this.m_truncateBox.setSelected(((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getTruncate());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 5;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_truncateBox, gbConstraints);
        db.add(this.m_truncateBox);
        JLabel idLab = new JLabel("Automatic primary key", 4);
        idLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 6;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(idLab, gbConstraints);
        db.add(idLab);
        this.m_idBox = new JCheckBox();
        this.m_idBox.setSelected(((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getAutoKeyGeneration());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 6;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_idBox, gbConstraints);
        db.add(this.m_idBox);
        JLabel propsLab = new JLabel("DB config props", 4);
        propsLab.setToolTipText("The custom properties that the user can use to override the default ones.");
        propsLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 7;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(propsLab, gbConstraints);
        db.add(propsLab);
        this.m_dbProps = new FileEnvironmentField();
        this.m_dbProps.setEnvironment(this.m_env);
        this.m_dbProps.resetFileFilters();
        this.m_dbProps.addFileFilter(new ExtensionFileFilter(".props", "DatabaseUtils property file (*.props)"));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 7;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_dbProps, gbConstraints);
        db.add(this.m_dbProps);
        File toSet = ((DatabaseSaver)this.m_dsSaver.getSaverTemplate()).getCustomPropsFile();
        if (toSet != null) {
            this.m_dbProps.setText(toSet.getPath());
        }
        JButton loadPropsBut = new JButton("Load");
        loadPropsBut.setToolTipText("Load config");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 7;
        gbConstraints.gridx = 2;
        gbLayout.setConstraints(loadPropsBut, gbConstraints);
        db.add(loadPropsBut);
        loadPropsBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SaverCustomizer.this.m_dbProps.getText() != null && SaverCustomizer.this.m_dbProps.getText().length() > 0) {
                    String propsS = SaverCustomizer.this.m_dbProps.getText();
                    try {
                        propsS = SaverCustomizer.this.m_env.substitute(propsS);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    File propsFile = new File(propsS);
                    if (propsFile.exists()) {
                        ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setCustomPropsFile(propsFile);
                        ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).resetOptions();
                        SaverCustomizer.this.m_dbaseURLText.setText(((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaverTemplate())).getUrl());
                    }
                }
            }
        });
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SaverCustomizer.this.m_dbProps.getText().length() > 0) {
                    ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setCustomPropsFile(new File(SaverCustomizer.this.m_dbProps.getText()));
                }
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).resetStructure();
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).resetOptions();
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaverTemplate())).setUrl(SaverCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaverTemplate())).setUser(SaverCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaverTemplate())).setPassword(new String(SaverCustomizer.this.m_passwordText.getPassword()));
                if (!SaverCustomizer.this.m_tabBox.isSelected()) {
                    ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setTableName(SaverCustomizer.this.m_tableText.getText());
                }
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setTruncate(SaverCustomizer.this.m_truncateBox.isSelected());
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setAutoKeyGeneration(SaverCustomizer.this.m_idBox.isSelected());
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaverTemplate()).setRelationForTableName(SaverCustomizer.this.m_tabBox.isSelected());
                if (SaverCustomizer.this.m_modifyListener != null) {
                    SaverCustomizer.this.m_modifyListener.setModifiedStatus(SaverCustomizer.this, true);
                }
                if (SaverCustomizer.this.m_parentWindow != null) {
                    SaverCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SaverCustomizer.this.m_modifyListener != null) {
                    SaverCustomizer.this.m_modifyListener.setModifiedStatus(SaverCustomizer.this, false);
                }
                if (SaverCustomizer.this.m_parentWindow != null) {
                    SaverCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
        JPanel holderP = new JPanel();
        holderP.setLayout(new BorderLayout());
        holderP.add((Component)db, "North");
        holderP.add((Component)buttonsP, "South");
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)holderP, "South");
    }

    public void setUpFile() {
        block12: {
            this.removeAll();
            this.m_fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Directory";
                }
            });
            this.m_fileChooser.setAcceptAllFileFilterUsed(false);
            try {
                if (this.m_dsSaver.getSaverTemplate().retrieveDir().equals("")) break block12;
                String dirStr = this.m_dsSaver.getSaverTemplate().retrieveDir();
                if (Environment.containsEnvVariables(dirStr)) {
                    try {
                        dirStr = this.m_env.substitute(dirStr);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                File tmp = new File(dirStr);
                tmp = new File(tmp.getAbsolutePath());
                this.m_fileChooser.setCurrentDirectory(tmp);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        JPanel alignedP = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        alignedP.setLayout(gbLayout);
        final JLabel prefixLab = new JLabel("Prefix for file name", 4);
        prefixLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(prefixLab, gbConstraints);
        alignedP.add(prefixLab);
        this.m_prefixText = new EnvironmentField();
        this.m_prefixText.setEnvironment(this.m_env);
        this.m_prefixText.setToolTipText("Prefix for file name (or filename itself if relation name is not used)");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_prefixText, gbConstraints);
        alignedP.add(this.m_prefixText);
        try {
            this.m_prefixText.setText(this.m_dsSaver.getSaverTemplate().filePrefix());
            JLabel relationLab = new JLabel("Relation name for filename", 4);
            relationLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 13;
            gbConstraints.fill = 2;
            gbConstraints.gridy = 1;
            gbConstraints.gridx = 0;
            gbLayout.setConstraints(relationLab, gbConstraints);
            alignedP.add(relationLab);
            this.m_relationNameForFilename = new JCheckBox();
            this.m_relationNameForFilename.setSelected(this.m_dsSaver.getRelationNameForFilename());
            if (this.m_dsSaver.getRelationNameForFilename()) {
                prefixLab.setText("Prefix for file name");
            } else {
                prefixLab.setText("File name");
            }
            this.m_relationNameForFilename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SaverCustomizer.this.m_relationNameForFilename.isSelected()) {
                        prefixLab.setText("Prefix for file name");
                    } else {
                        prefixLab.setText("File name");
                    }
                }
            });
            gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 13;
            gbConstraints.fill = 2;
            gbConstraints.gridy = 1;
            gbConstraints.gridx = 1;
            gbConstraints.weightx = 5.0;
            gbLayout.setConstraints(this.m_relationNameForFilename, gbConstraints);
            alignedP.add(this.m_relationNameForFilename);
        }
        catch (Exception ex) {
            // empty catch block
        }
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            innerPanel.add((Component)about, "North");
        }
        this.add((Component)innerPanel, "North");
        JLabel directoryLab = new JLabel("Directory", 4);
        directoryLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(directoryLab, gbConstraints);
        alignedP.add(directoryLab);
        this.m_directoryText = new EnvironmentField();
        this.m_directoryText.setEnvironment(this.m_env);
        try {
            this.m_directoryText.setText(this.m_dsSaver.getSaverTemplate().retrieveDir());
        }
        catch (IOException ex) {
            // empty catch block
        }
        JButton browseBut = new JButton("Browse...");
        browseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JDialog jf = new JDialog((Window)((JDialog)SaverCustomizer.this.getTopLevelAncestor()), "Choose directory", Dialog.ModalityType.DOCUMENT_MODAL);
                    jf.setLayout(new BorderLayout());
                    jf.getContentPane().add((Component)SaverCustomizer.this.m_fileChooser, "Center");
                    SaverCustomizer.this.m_fileChooserFrame = jf;
                    jf.pack();
                    jf.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel efHolder = new JPanel();
        efHolder.setLayout(new BorderLayout());
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        bP.add((Component)browseBut, "Center");
        efHolder.add((Component)this.m_directoryText, "Center");
        efHolder.add((Component)bP, "East");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(efHolder, gbConstraints);
        alignedP.add(efHolder);
        JLabel relativeLab = new JLabel("Use relative file paths", 4);
        relativeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(relativeLab, gbConstraints);
        alignedP.add(relativeLab);
        this.m_relativeFilePath = new JCheckBox();
        this.m_relativeFilePath.setSelected(((FileSourcedConverter)((Object)this.m_dsSaver.getSaverTemplate())).getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FileSourcedConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaverTemplate())).setUseRelativePath(SaverCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_relativeFilePath, gbConstraints);
        alignedP.add(this.m_relativeFilePath);
        JButton OKBut = new JButton("OK");
        OKBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SaverCustomizer.this.m_dsSaver.getSaverTemplate().setFilePrefix(SaverCustomizer.this.m_prefixText.getText());
                    SaverCustomizer.this.m_dsSaver.getSaverTemplate().setDir(SaverCustomizer.this.m_directoryText.getText());
                    SaverCustomizer.this.m_dsSaver.setRelationNameForFilename(SaverCustomizer.this.m_relationNameForFilename.isSelected());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (SaverCustomizer.this.m_modifyListener != null) {
                    SaverCustomizer.this.m_modifyListener.setModifiedStatus(SaverCustomizer.this, true);
                }
                SaverCustomizer.this.m_parentWindow.dispose();
            }
        });
        JButton CancelBut = new JButton("Cancel");
        CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SaverCustomizer.this.m_modifyListener != null) {
                    SaverCustomizer.this.m_modifyListener.setModifiedStatus(SaverCustomizer.this, false);
                }
                SaverCustomizer.this.m_parentWindow.dispose();
            }
        });
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new FlowLayout());
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        JPanel holder2 = new JPanel();
        holder2.setLayout(new BorderLayout());
        holder2.add((Component)alignedP, "North");
        JPanel optionsHolder = new JPanel();
        optionsHolder.setLayout(new BorderLayout());
        optionsHolder.setBorder(BorderFactory.createTitledBorder("Other options"));
        optionsHolder.add((Component)this.m_SaverEditor, "South");
        JScrollPane scroller = new JScrollPane(optionsHolder);
        innerPanel.add((Component)holder2, "South");
        this.add((Component)scroller, "Center");
        this.add((Component)butHolder, "South");
    }

    @Override
    public void setObject(Object object) {
        this.m_dsSaver = (Saver)object;
        this.m_SaverEditor.setTarget(this.m_dsSaver.getSaverTemplate());
        if (this.m_dsSaver.getSaverTemplate() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else if (this.m_dsSaver.getSaverTemplate() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else {
            this.setUpOther();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

