/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AddClassification;

public class AddClassificationTest
extends AbstractFilterTest {
    public AddClassificationTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return new AddClassification();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.deleteAttributeType(2);
        this.m_Instances.setClassIndex(0);
    }

    protected void performTest(boolean num, boolean cl, boolean dist, boolean error, boolean remove) {
        if (num) {
            this.m_Instances.setClassIndex(1);
        } else {
            this.m_Instances.setClassIndex(0);
        }
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        if (num) {
            ((AddClassification)this.m_Filter).setClassifier((Classifier)new M5P());
        } else {
            ((AddClassification)this.m_Filter).setClassifier((Classifier)new J48());
        }
        ((AddClassification)this.m_Filter).setOutputClassification(cl);
        ((AddClassification)this.m_Filter).setOutputDistribution(dist);
        ((AddClassification)this.m_Filter).setOutputErrorFlag(error);
        ((AddClassification)this.m_Filter).setRemoveOldClass(remove);
        int numAtts = icopy.numAttributes();
        if (cl) {
            ++numAtts;
        }
        if (dist) {
            numAtts += icopy.numClasses();
        }
        if (error) {
            ++numAtts;
        }
        if (remove) {
            --numAtts;
        }
        Instances result = this.useFilter();
        AddClassificationTest.assertEquals((int)result.numAttributes(), (int)numAtts);
    }

    public void testDefault() {
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        AddClassificationTest.assertEquals((int)result.numAttributes(), (int)icopy.numAttributes());
    }

    public void testNoneNominal() {
        this.performTest(false, false, false, false, false);
    }

    public void testErrorFlagNominal() {
        this.performTest(false, false, false, true, false);
    }

    public void testClassificationNominal() {
        this.performTest(false, true, false, false, false);
    }

    public void testDistributionNominal() {
        this.performTest(false, false, true, false, false);
    }

    public void testNoneNumeric() {
        this.performTest(true, false, false, false, false);
    }

    public void testErrorFlagNumeric() {
        this.performTest(true, false, false, true, false);
    }

    public void testClassificationNumeric() {
        this.performTest(true, true, false, false, false);
    }

    public void testDistributionNumeric() {
        this.performTest(true, false, true, false, false);
    }

    public static Test suite() {
        return new TestSuite(AddClassificationTest.class);
    }

    public void testClassificationRemoveNominal() {
        this.performTest(false, true, false, false, true);
    }

    public void testClassificationRemoveNumeric() {
        this.performTest(true, true, false, false, true);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddClassificationTest.suite());
    }

    public void testClassificationOnlyRemoveNominal() {
        this.performTest(false, false, false, false, true);
    }

    public void testClassificationOnlyRemoveNumeric() {
        this.performTest(true, false, false, false, true);
    }
}

