/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;
import org.ujmp.core.util.MathUtil;

public class JDBCSparseObjectMatrix
extends AbstractSparseObjectMatrix
implements Closeable,
Erasable {
    private static final long serialVersionUID = -5801269687893136766L;
    private boolean useExtendedSQL = false;
    private transient Connection connection = null;
    private transient PreparedStatement getEntryStatement = null;
    private transient PreparedStatement insertEntryStatement = null;
    private transient PreparedStatement deleteEntryStatement = null;
    private transient PreparedStatement selectAllStatement = null;
    private final String url;
    private final String username;
    private String password = null;
    private final String tableName;
    private final String[] columnsForCoordinates;
    private final String columnForValue;
    private final long[] size;

    public JDBCSparseObjectMatrix(long ... size) throws ClassNotFoundException, IOException, SQLException {
        this(size, "jdbc:hsqldb:" + File.createTempFile("hsqldbtemp", "").getAbsolutePath() + ";shutdown=true", "SA", "", "matrixTable", "valueColumn", JDBCSparseObjectMatrix.createColumnNames(size));
    }

    private static String[] createColumnNames(long ... size) {
        String[] cols = new String[size.length];
        int c = size.length;
        while (--c != -1) {
            cols[c] = "column" + c;
        }
        return cols;
    }

    public JDBCSparseObjectMatrix(long[] size, String url, String username, String password, String tableName, String columnForValue, String ... columnsForCoordinates) throws ClassNotFoundException, SQLException {
        this.url = url;
        this.size = size;
        this.username = username;
        this.password = password;
        this.tableName = tableName;
        this.columnForValue = columnForValue;
        this.columnsForCoordinates = columnsForCoordinates;
        if (url.startsWith("jdbc:hsqldb:")) {
            Class.forName("org.hsqldb.jdbcDriver");
        } else if (url.startsWith("jdbc:mysql:")) {
            Class.forName("org.mysql.jdbc.Driver");
        } else if (url.startsWith("jdbc:postgresql:")) {
            Class.forName("org.postgresql.Driver");
        } else if (url.startsWith("jdbc:derby:")) {
            Class.forName("org.apache.derby.jdbc.Driver40");
        }
        this.createTableIfNotExists();
    }

    public JDBCSparseObjectMatrix(long[] size, Connection connection, String tableName, String columnForValue, String ... columnsForCoordinates) throws SQLException {
        this.size = size;
        this.connection = connection;
        this.username = connection.getMetaData().getUserName();
        this.url = connection.getMetaData().getURL();
        this.tableName = tableName;
        this.columnForValue = columnForValue;
        this.columnsForCoordinates = columnsForCoordinates;
        this.createTableIfNotExists();
    }

    private void createTableIfNotExists() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(this.tableName);
        sb.append(" (valueColumn float");
        String[] stringArray = this.columnsForCoordinates;
        int n = this.columnsForCoordinates.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            sb.append(", ").append(c).append(" int");
            ++n2;
        }
        sb.append(")");
        statement.execute(sb.toString());
    }

    private PreparedStatement getSelectAllStatement() throws SQLException {
        if (this.selectAllStatement == null) {
            StringBuilder s = new StringBuilder();
            s.append("select ");
            s.append(this.columnForValue);
            s.append(", ");
            int i = 0;
            while (i < this.columnsForCoordinates.length) {
                s.append(this.columnsForCoordinates[i]);
                if (i < this.columnsForCoordinates.length - 1) {
                    s.append(", ");
                }
                ++i;
            }
            s.append(" from ");
            s.append(this.tableName);
            this.selectAllStatement = this.getConnection().prepareStatement(s.toString());
        }
        return this.selectAllStatement;
    }

    private PreparedStatement getGetEntryStatement() throws SQLException {
        if (this.getEntryStatement == null) {
            StringBuilder s = new StringBuilder();
            s.append("select ");
            s.append(this.columnForValue);
            s.append(" from ");
            s.append(this.tableName);
            s.append(" where ");
            int i = 0;
            while (i < this.columnsForCoordinates.length) {
                s.append(this.columnsForCoordinates[i]);
                s.append("=?");
                if (i < this.columnsForCoordinates.length - 1) {
                    s.append(" and ");
                }
                ++i;
            }
            this.getEntryStatement = this.getConnection().prepareStatement(s.toString());
        }
        return this.getEntryStatement;
    }

    private PreparedStatement getInsertEntryStatement() throws SQLException {
        if (this.insertEntryStatement == null) {
            StringBuilder s = new StringBuilder();
            s.append("insert into ");
            s.append(this.tableName);
            s.append(" (");
            s.append(this.columnForValue);
            s.append(", ");
            int i = 0;
            while (i < this.columnsForCoordinates.length) {
                s.append(this.columnsForCoordinates[i]);
                if (i < this.columnsForCoordinates.length - 1) {
                    s.append(", ");
                }
                ++i;
            }
            s.append(") values (?, ");
            i = 0;
            while (i < this.columnsForCoordinates.length) {
                s.append("?");
                if (i < this.columnsForCoordinates.length - 1) {
                    s.append(", ");
                }
                ++i;
            }
            s.append(")");
            if (this.useExtendedSQL) {
                s.append(" on duplicate key update ");
                s.append(this.columnForValue);
                s.append("=?");
            }
            this.insertEntryStatement = this.getConnection().prepareStatement(s.toString());
        }
        return this.insertEntryStatement;
    }

    private PreparedStatement getDeleteEntryStatement() throws SQLException {
        if (this.deleteEntryStatement == null) {
            StringBuilder s = new StringBuilder();
            s.append("delete from ");
            s.append(this.tableName);
            s.append(" where ");
            int i = 0;
            while (i < this.columnsForCoordinates.length) {
                s.append(this.columnsForCoordinates[i]);
                s.append("=?");
                if (i < this.columnsForCoordinates.length - 1) {
                    s.append(" and ");
                }
                ++i;
            }
            this.deleteEntryStatement = this.getConnection().prepareStatement(s.toString());
        }
        return this.deleteEntryStatement;
    }

    public synchronized Object getObject(long ... coordinates) {
        try {
            PreparedStatement ps = this.getGetEntryStatement();
            int i = 0;
            while (i < coordinates.length) {
                ps.setLong(i + 1, coordinates[i]);
                ++i;
            }
            ResultSet rs = ps.executeQuery();
            Object o = null;
            if (rs.next()) {
                o = rs.getObject(1);
            }
            rs.close();
            return o;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    private void deleteObject(long ... coordinates) throws SQLException {
        PreparedStatement ps = this.getDeleteEntryStatement();
        int i = 0;
        while (i < coordinates.length) {
            ps.setLong(i + 1, coordinates[i]);
            ++i;
        }
        ps.execute();
    }

    public synchronized void setObject(Object value, long ... coordinates) {
        try {
            if (MathUtil.getDouble(value) == 0.0) {
                this.deleteObject(coordinates);
            } else {
                if (!this.useExtendedSQL) {
                    this.deleteObject(coordinates);
                }
                PreparedStatement ps = this.getInsertEntryStatement();
                ps.setObject(1, value);
                int i = 0;
                while (i < coordinates.length) {
                    ps.setLong(i + 2, coordinates[i]);
                    ++i;
                }
                if (this.useExtendedSQL) {
                    ps.setObject(coordinates.length + 2, value);
                }
                ps.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public synchronized long[] getSize() {
        return this.size;
    }

    public synchronized void close() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return this.connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean contains(long ... coordinates) throws MatrixException {
        return this.getObject(coordinates) != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.connection != null) {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
            this.connection = null;
        }
    }

    public void erase() throws IOException {
        String[] s;
        try {
            Statement st = this.getConnection().createStatement();
            st.execute("drop table " + this.tableName);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        this.close();
        if (this.url.contains("hsqldbtemp") && (s = this.url.split(":")).length > 2) {
            File file4;
            File file3;
            File file2;
            String file = "";
            int i = 2;
            while (i < s.length) {
                file = String.valueOf(file) + s[i];
                if (i < s.length - 1) {
                    file = String.valueOf(file) + ":";
                }
                ++i;
            }
            s = file.split(";");
            File file1 = new File(file = s[0]);
            if (file1.exists()) {
                file1.delete();
            }
            if ((file2 = new File(String.valueOf(file) + ".log")).exists()) {
                file2.delete();
            }
            if ((file3 = new File(String.valueOf(file) + ".properties")).exists()) {
                file3.delete();
            }
            if ((file4 = new File(String.valueOf(file) + ".script")).exists()) {
                file4.delete();
            }
        }
    }
}

