/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree.util;

public class DoubleVector {
    public static void addVectors(double[] a1, double[] a2) {
        assert (a1 != null);
        assert (a2 != null);
        assert (a1.length == a2.length) : "Adding two arrays of different length";
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] + a2[i];
        }
    }

    public static double[] copyVector(double[] a) {
        int length = a.length;
        double[] res = new double[length];
        System.arraycopy(a, 0, res, 0, length);
        return res;
    }

    public static void normalizeVector(double[] a) {
        double length = DoubleVector.calculateLength(a);
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] / length;
        }
    }

    public static void multiplyVector(double[] a, double f) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * f;
        }
    }

    public static double calculateLength(double[] a) {
        double length = 0.0;
        for (int i = 0; i < a.length; ++i) {
            length += a[i] * a[i];
        }
        return Math.sqrt(length);
    }

    public static double calculateDistance(double[] a1, double[] a2) {
        assert (a1.length == a2.length);
        double distance = 0.0;
        int length = a1.length;
        for (int i = 0; i < length; ++i) {
            double d = a1[i] - a2[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public static boolean isZero(double[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public static void addConstant(double[] vector, double c) {
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] + c;
        }
    }
}

