/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Properties;
import adams.core.io.ConsoleLog;
import adams.env.Environment;
import java.io.Serializable;

public abstract class Log
implements Serializable {
    private static final long serialVersionUID = -3404920421654324738L;
    public static final String FILENAME = "Log.props";
    public static final String KEY_DEFAULTCLASS = "DefaultClass";
    public static final String KEY_ENABLED = "Enabled";
    protected static Properties m_Properties;
    protected static Log m_Singleton;
    protected boolean m_Enabled;

    public Log() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Enabled = Log.getProperties().getBoolean(KEY_ENABLED, false);
    }

    protected abstract void doLog(String var1, boolean var2, boolean var3);

    public void printOut(String msg) {
        if (this.m_Enabled) {
            this.doLog(msg, true, false);
        }
    }

    public void printErr(String msg) {
        if (this.m_Enabled) {
            this.doLog(msg, false, false);
        }
    }

    public void printlnOut(String msg) {
        if (this.m_Enabled) {
            this.doLog(msg, true, true);
        }
    }

    public void printlnErr(String msg) {
        if (this.m_Enabled) {
            this.doLog(msg, false, true);
        }
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("log");
        }
        return m_Properties;
    }

    protected String getPropertyKey(String suffix) {
        return this.getClass().getName() + "." + suffix;
    }

    public static synchronized Log getSingleton() {
        if (m_Singleton == null) {
            try {
                String classname = Log.getProperties().getString(KEY_DEFAULTCLASS);
                m_Singleton = (Log)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                m_Singleton = new ConsoleLog();
            }
        }
        return m_Singleton;
    }
}

