/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.Mergeable;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreFilter<T extends DataContainer & Mergeable>
extends AbstractFilter<T> {
    private static final long serialVersionUID = -631871037799637776L;
    protected AbstractFilter m_Filter;

    @Override
    public String globalInfo() {
        return "A filter that removes noise from the GC data with a user-supplied noise level algorithm.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", this.getDefaultFilter());
    }

    protected AbstractFilter getDefaultFilter() {
        return new PassThrough();
    }

    public void setFilter(AbstractFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "Pre-filters the data, .";
    }

    protected abstract T processData(T var1, T var2);

    @Override
    protected T processData(T data) {
        AbstractFilter filter = this.m_Filter.shallowCopy(true);
        T filtered = filter.filter(data);
        filter.destroy();
        T result = this.processData(filtered, data);
        return result;
    }
}

