/*
 * Decompiled with CFR 0.152.
 */
package adams.data.id;

import adams.core.Placeholders;
import adams.core.Utils;
import adams.data.id.AbstractIDGenerator;
import adams.data.id.SimpleIDGenerator;

public class IDGeneratorPostProcessor
extends AbstractIDGenerator {
    private static final long serialVersionUID = 3108348760412162025L;
    protected AbstractIDGenerator m_Generator;
    protected String m_Find;
    protected String m_Replace;
    protected boolean m_ReplaceAll;
    protected boolean m_ReplaceContainsPlaceholder;

    public String globalInfo() {
        return "A simple ID generator that can make use of data provided by classes implementing IDHandler and DatabaseIDHandler.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new SimpleIDGenerator());
        this.m_OptionManager.add("find", "find", "find");
        this.m_OptionManager.add("replace", "replace", "");
        this.m_OptionManager.add("all", "replaceAll", false);
        this.m_OptionManager.add("placeholder", "replaceContainsPlaceholder", false);
    }

    public void setGenerator(AbstractIDGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractIDGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the IDs.";
    }

    public void setFind(String value) {
        this.m_Find = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getFind() {
        return Utils.backQuoteChars(this.m_Find);
    }

    public String findTipText() {
        return "The string to find (a regular expression).";
    }

    public void setReplace(String value) {
        this.m_Replace = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getReplace() {
        return Utils.backQuoteChars(this.m_Replace);
    }

    public String replaceTipText() {
        return "The string to replace the occurrences with.";
    }

    public void setReplaceAll(boolean value) {
        this.m_ReplaceAll = value;
        this.reset();
    }

    public boolean getReplaceAll() {
        return this.m_ReplaceAll;
    }

    public String replaceAllTipText() {
        return "If set to true, then all occurrences will be replaced; otherwise only the first.";
    }

    public void setReplaceContainsPlaceholder(boolean value) {
        this.m_ReplaceContainsPlaceholder = value;
        this.reset();
    }

    public boolean getReplaceContainsPlaceholder() {
        return this.m_ReplaceContainsPlaceholder;
    }

    public String replaceContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the replacement string.";
    }

    protected String assemble(Object o) {
        String result = this.m_Generator.generate(o);
        String actReplace = this.m_ReplaceContainsPlaceholder ? Placeholders.getSingleton().expand(this.m_Replace).replace("\\", "/") : this.m_Replace;
        result = this.m_ReplaceAll ? result.replaceAll(this.m_Find, actReplace) : result.replaceFirst(this.m_Find, actReplace);
        return result;
    }
}

