/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.SuffixOnlyField;

public class SuffixField
extends Field
implements SuffixOnlyField {
    private static final long serialVersionUID = 8407023575940681345L;
    public static final String DUMMY_PREFIX = "DUMMY";

    public SuffixField() {
        this(null, DataType.UNKNOWN);
    }

    public SuffixField(AbstractField field) {
        this(field.getName(), field.getDataType());
    }

    public SuffixField(String name, DataType dt) {
        super(name, dt);
        if (this.m_Name != null) {
            this.m_Name = !this.isCompound() ? "DUMMY\t" + this.m_Name : "DUMMY\t" + this.getSuffix();
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        AbstractField f = (AbstractField)o;
        if (this.getSuffix() == null && f.getSuffix() == null) {
            return 0;
        }
        if (this.getSuffix() == null) {
            return -1;
        }
        if (f.getSuffix() == null) {
            return 1;
        }
        return this.getSuffix().toLowerCase().compareTo(f.getSuffix().toLowerCase());
    }

    public String toString() {
        if (this.m_Name == null || this.m_Name.length() == 0) {
            return "";
        }
        return this.getSuffix();
    }

    public String toDisplayString() {
        return this.toString();
    }

    protected AbstractField newField(String name, DataType dtype) {
        return new SuffixField(name, dtype);
    }

    public static SuffixField parseField(String s) {
        AbstractField tmp = Field.parseField(s);
        SuffixField result = new SuffixField(tmp);
        return result;
    }
}

