/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.ifthenelse.AbstractIfThenElseCondition;
import adams.flow.condition.ifthenelse.Expression;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfThenElse
extends AbstractDirectedControlActor
implements InputConsumer {
    private static final long serialVersionUID = 185561131623293880L;
    public static final String BACKUP_INPUT = "input";
    public static final String BACKUP_CONDITION = "condition";
    protected AbstractIfThenElseCondition m_Condition;
    protected AbstractIfThenElseCondition m_ActualCondition;
    protected AbstractActor m_ThenActor;
    protected AbstractActor m_ElseActor;
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Emulates an If-Then-Else construct. The 'Then' branch gets executed if the 'If' condition evaluates to 'true', otherwise the 'else' branch gets executed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CONDITION, BACKUP_CONDITION, this.getDefaultCondition());
        this.m_OptionManager.add("then", "thenActor", this.getDefaultThen());
        this.m_OptionManager.add("else", "elseActor", this.getDefaultElse());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_InputToken = null;
        this.m_ThenActor = this.getDefaultThen();
        this.m_ElseActor = this.getDefaultElse();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ActualCondition = null;
    }

    @Override
    public String getQuickInfo() {
        return this.m_Condition.getQuickInfo();
    }

    protected AbstractIfThenElseCondition getDefaultCondition() {
        return new Expression();
    }

    protected AbstractActor getDefaultThen() {
        Sequence result = new Sequence();
        result.setName("then");
        return result;
    }

    protected AbstractActor getDefaultElse() {
        Sequence result = new Sequence();
        result.setName("else");
        return result;
    }

    @Override
    protected AbstractDirector newDirector() {
        return new IfThenElseDirector();
    }

    public void setCondition(AbstractIfThenElseCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    public AbstractIfThenElseCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition that determines which branch to execute: if it evaluates to 'true' then the 'then' branch gets executed.";
    }

    protected AbstractIfThenElseCondition getActualCondition() {
        return this.m_ActualCondition;
    }

    public void setThenActor(AbstractActor value) {
        ActorUtils.uniqueName(value, this, 0);
        this.m_ThenActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getThenActor() {
        return this.m_ThenActor;
    }

    public String thenActorTipText() {
        return "The actor of the 'then' branch.";
    }

    public void setElseActor(AbstractActor value) {
        ActorUtils.uniqueName(value, this, 1);
        this.m_ElseActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getElseActor() {
        return this.m_ElseActor;
    }

    public String elseActorTipText() {
        return "The actor of the 'else' branch.";
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_ThenActor;
        }
        if (index == 1) {
            return this.m_ElseActor;
        }
        throw new IndexOutOfBoundsException("Only two items available, requested index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index == 0) {
            this.setThenActor(actor);
        } else if (index == 1) {
            this.setElseActor(actor);
        } else {
            this.getSystemErr().println("Index out of range: " + index);
        }
    }

    @Override
    public int indexOf(String actor) {
        if (this.m_ThenActor.getName().equals(actor)) {
            return 0;
        }
        if (this.m_ElseActor.getName().equals(actor)) {
            return 1;
        }
        return -1;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
    }

    @Override
    public Class[] accepts() {
        return this.m_Condition.accepts();
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        if (this.m_ActualCondition != null) {
            result.put(BACKUP_CONDITION, this.m_ActualCondition);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CONDITION)) {
            this.m_ActualCondition = (AbstractIfThenElseCondition)state.get(BACKUP_CONDITION);
            state.remove(BACKUP_CONDITION);
        }
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            ((IfThenElseDirector)this.m_Director).setBranchToken(this.m_InputToken);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualCondition = this.m_Condition.shallowCopy();
            result = this.m_ActualCondition.setUp();
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        ((IfThenElseDirector)this.m_Director).setBranchToken(this.m_InputToken);
    }

    @Override
    public void cleanUp() {
        this.m_InputToken = null;
        super.cleanUp();
    }

    public static class IfThenElseDirector
    extends AbstractDirector {
        private static final long serialVersionUID = 8414511259688024553L;
        protected transient Token m_BranchToken;

        protected void setIfThenElseActor(AbstractDirectedControlActor value) {
            super.setControlActor(value);
        }

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof IfThenElse || value == null) {
                this.setIfThenElseActor(value);
            } else {
                System.err.println("Control actor must be a IfThenElse actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        public void setBranchToken(Token value) {
            this.m_BranchToken = value;
        }

        public Token getBranchToken() {
            return this.m_BranchToken;
        }

        protected boolean doThen() {
            IfThenElse owner = (IfThenElse)this.getControlActor();
            if (owner.getActualCondition() == null) {
                throw new IllegalStateException("No configured condition available??");
            }
            return owner.getActualCondition().doThen(owner, this.m_BranchToken);
        }

        public String execute() {
            String result;
            AbstractActor branch = this.doThen() ? ((IfThenElse)this.m_ControlActor).getThenActor() : ((IfThenElse)this.m_ControlActor).getElseActor();
            try {
                if (this.m_BranchToken != null && branch instanceof InputConsumer) {
                    ((InputConsumer)((Object)branch)).input(this.m_BranchToken);
                }
                result = branch.execute();
            }
            catch (Exception e) {
                String msg = branch.getFullName() + " generated the following exception: ";
                result = msg + e;
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
            if (result != null) {
                branch.handleError("execute", result);
            }
            return result;
        }

        public void cleanUp() {
            this.m_BranchToken = null;
            super.cleanUp();
        }
    }
}

