/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.core.AbstractActor;
import adams.flow.core.ControlActor;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class Sleep
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = -3383735680425581504L;
    protected int m_Interval;

    public String globalInfo() {
        return "Waits for a fixed amount of milli-seconds.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", 1000);
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval in milli-seconds to wait before continuing with the execution.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("interval");
        if (variable != null) {
            return variable + " ms";
        }
        return this.m_Interval + "ms";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.wait(this.m_Interval);
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.m_Self.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }
}

