/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.CloneHandler;
import adams.core.Utils;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.gui.flow.provenance.ProvenanceNode;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements Serializable,
CloneHandler<Token>,
ProvenanceContainer {
    private static final long serialVersionUID = -619575965753741493L;
    protected Object m_Payload;
    protected ProvenanceNode m_Provenance;

    public Token() {
        this(null);
    }

    public Token(Object payload) {
        this.setPayload(payload);
        this.setProvenance(null);
    }

    public void setPayload(Object value) {
        this.m_Payload = value;
    }

    public Object getPayload() {
        return this.m_Payload;
    }

    public boolean isNull() {
        return this.m_Payload == null;
    }

    @Override
    public boolean hasProvenance() {
        return this.m_Provenance != null;
    }

    @Override
    public void setProvenance(ProvenanceNode value) {
        this.m_Provenance = value;
    }

    @Override
    public ProvenanceNode getProvenance() {
        return this.m_Provenance;
    }

    @Override
    public void addProvenance(ProvenanceInformation info) {
        if (!Provenance.getSingleton().isEnabled()) {
            return;
        }
        ProvenanceNode node = new ProvenanceNode(null, info);
        if (this.m_Provenance != null) {
            ProvenanceNode child = this.m_Provenance;
            node.add(child);
        }
        this.m_Provenance = node;
    }

    @Override
    public void mergeProvenance(ProvenanceInformation info, ProvenanceNode[] parents) {
        if (!Provenance.getSingleton().isEnabled()) {
            return;
        }
        this.m_Provenance = new ProvenanceNode(null, info);
        for (ProvenanceNode parent : parents) {
            this.m_Provenance.add(parent);
        }
    }

    @Override
    public Token getClone() {
        Token result = new Token();
        if (!this.isNull() && this.m_Payload instanceof Serializable) {
            result.setPayload(Utils.deepCopy(this.m_Payload));
        } else if (!this.isNull() && this.m_Payload instanceof CloneHandler) {
            result.setPayload(((CloneHandler)this.m_Payload).getClone());
        } else {
            result.setPayload(this.m_Payload);
        }
        if (Provenance.getSingleton().isEnabled()) {
            result.setProvenance(this.m_Provenance.getClone());
        }
        return result;
    }

    public int hashCode() {
        if (this.isNull()) {
            return "".hashCode();
        }
        return this.m_Payload.hashCode();
    }

    public String toString() {
        return "Token #" + this.hashCode() + ": " + (this.isNull() ? "null" : this.m_Payload.toString());
    }
}

