/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.AbstractDirector;
import adams.flow.control.MutableControlActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import java.util.HashSet;

public class GlobalActors
extends MutableControlActor {
    private static final long serialVersionUID = -5282103315016094476L;

    public String globalInfo() {
        return "Container for actors that need to be accessed globally via their name.";
    }

    protected AbstractDirector newDirector() {
        return new GlobalActorsDirector();
    }

    public String actorsTipText() {
        return "All the actors that are to be accessed globally via their name.";
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.PARALLEL, false);
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            for (int i = 0; i < this.size() && (this.get(i).getSkip() || (result = this.get(i).setUp()) == null); ++i) {
            }
        }
        return result;
    }

    protected String checkNames() {
        String result = null;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (names.contains(this.get(i).getName())) {
                result = "Actor '" + this.get(i).getFullName() + "' has duplicate name '" + this.get(i).getName() + "'!";
                break;
            }
            names.add(this.get(i).getName());
        }
        return result;
    }

    public String check() {
        return this.checkNames();
    }

    protected String doExecute() {
        return null;
    }

    public void wrapUp() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).wrapUp();
        }
        super.wrapUp();
    }

    public static class GlobalActorsDirector
    extends AbstractDirector {
        private static final long serialVersionUID = -7581710637774405432L;

        public String execute() {
            return null;
        }
    }
}

