/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.TransferableString;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragAndDropTreeNodeCollection<N extends BaseTreeNode>
implements Transferable,
Serializable,
Collection<N> {
    private static final long serialVersionUID = -7713547721629308103L;
    protected ArrayList<N> m_Nodes = new ArrayList();

    private DragAndDropTreeNodeCollection() {
    }

    public DragAndDropTreeNodeCollection(N[] nodes) {
        this();
        this.m_Nodes.addAll(Arrays.asList(nodes));
    }

    @Override
    public int size() {
        return this.m_Nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_Nodes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_Nodes.contains(o);
    }

    @Override
    public Iterator<N> iterator() {
        return this.m_Nodes.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_Nodes.toArray();
    }

    @Override
    public <N> N[] toArray(N[] a) {
        return this.m_Nodes.toArray(a);
    }

    @Override
    public boolean add(N e) {
        return this.m_Nodes.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.m_Nodes.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_Nodes.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends N> c) {
        return this.m_Nodes.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.m_Nodes.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.m_Nodes.retainAll(c);
    }

    @Override
    public void clear() {
        this.m_Nodes.clear();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.toTransferable();
    }

    public Transferable toTransferable() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(((BaseTreeNode)this.m_Nodes.get(i)).toString());
        }
        return new TransferableString(result.toString());
    }
}

