/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.SpreadSheet;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetCellRenderer;
import adams.gui.core.SpreadSheetTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheetTable
extends SortableAndSearchableTable {
    private static final long serialVersionUID = 1333317577811620786L;

    public SpreadSheetTable(SpreadSheet sheet) {
        this(new SpreadSheetTableModel(sheet));
    }

    public SpreadSheetTable(SpreadSheetTableModel model) {
        super(model);
    }

    protected void setCustomCellRenderer() {
        SpreadSheetCellRenderer renderer = new SpreadSheetCellRenderer();
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
        }
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.setCustomCellRenderer();
    }

    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    protected boolean initialSortNewTableModel() {
        return false;
    }

    protected Class getTableModelClass() {
        return SpreadSheetTableModel.class;
    }

    protected TableModel createDefaultDataModel() {
        return new SpreadSheetTableModel();
    }

    public SpreadSheet.Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheetTableModel sheetmodel = (SpreadSheetTableModel)this.getUnsortedModel();
        SpreadSheet.Cell result = sheetmodel.getCellAt(this.getActualRow(rowIndex), columnIndex);
        return result;
    }

    public void setNumDecimals(int value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNumDecimals(value);
    }

    public int getNumDecimals() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNumDecimals();
    }

    public SpreadSheet getSheet() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getSheet();
    }
}

