/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import adams.db.ReconnectableDatabaseConnection;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.AbstractDatabaseConnectionPanel;

public abstract class AbstractConfigDatabaseConnectionPanel
extends AbstractDatabaseConnectionPanel {
    private static final long serialVersionUID = -5065572637368668864L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected void doReconnect() {
        this.m_ButtonConnect.setEnabled(false);
        if (this.getDatabaseConnection().isConnected()) {
            this.showStatus("Disconnecting...");
            this.getDatabaseConnection().disconnect();
        } else {
            this.showStatus("Connecting...");
            if (!((ReconnectableDatabaseConnection)((Object)this.getDatabaseConnection())).reconnect(this.m_TextURL.getText(), this.m_TextUser.getText(), new BasePassword(this.m_TextPassword.getText()))) {
                GUIHelper.showErrorMessage(this.m_Self, "Failed to connect to " + this.m_TextURL.getText());
            } else {
                this.getDatabaseConnection().addConnection(this.getDatabaseConnection().getCurrentConnection());
                if (this.getDatabaseConnection().getOwner() != null) {
                    this.getDatabaseConnection().getOwner().setDefault(this.getDatabaseConnection());
                }
            }
        }
        this.m_ButtonConnect.setEnabled(true);
        this.notifyChangeListeners();
        this.showStatus("");
        this.update();
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }
}

