/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tree.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class Renderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -2445498431457837008L;
    public static final Color BACKGROUND_EDITING_DEBUG = ColorHelper.valueOf("#FFDDEE");
    public static final Color BACKGROUND_RUNNING_DEBUG = ColorHelper.valueOf("#CC99CC");
    public static final Color BACKGROUND_RUNNING = Color.LIGHT_GRAY;
    public static final Color COLOR_DEPRECATED = Color.RED;
    public static final Color COLOR_VISUALCUES = Color.BLACK;
    public static final String ICON_PREFIX = "adams.flow.";
    public static final int BORDER_WIDTH = 3;
    protected Hashtable<String, ImageIcon> m_Icons = new Hashtable();
    protected double m_ScaleFactor;

    public Renderer() {
        this(1.0);
    }

    public Renderer(double scaleFactor) {
        this.m_ScaleFactor = scaleFactor;
    }

    public double getScaleFactor() {
        return this.m_ScaleFactor;
    }

    protected ActorIcon getIcon(AbstractActor parent, AbstractActor actor, boolean collapsed) {
        ActorIcon result = null;
        ImageIcon icon = null;
        String classname = actor.getClass().getName();
        ActorExecution execution = ActorExecution.UNDEFINED;
        if (parent != null && parent instanceof ActorHandler) {
            execution = ((ActorHandler)((Object)parent)).getActorHandlerInfo().getActorExecution();
        }
        if (this.m_Icons.containsKey(classname)) {
            icon = this.m_Icons.get(classname);
        } else {
            block12: {
                try {
                    icon = GUIHelper.getIcon(actor.getClass());
                }
                catch (Exception e) {
                    if (ActorUtils.isControlActor(actor)) {
                        icon = GUIHelper.getIcon("adams.flow.control.Unknown.gif");
                    }
                    if (ActorUtils.isStandalone(actor)) {
                        icon = GUIHelper.getIcon("adams.flow.standalone.Unknown.gif");
                    }
                    if (ActorUtils.isSource(actor)) {
                        icon = GUIHelper.getIcon("adams.flow.source.Unknown.gif");
                    }
                    if (ActorUtils.isTransformer(actor)) {
                        icon = GUIHelper.getIcon("adams.flow.transformer.Unknown.gif");
                    }
                    if (!ActorUtils.isSink(actor)) break block12;
                    icon = GUIHelper.getIcon("adams.flow.sink.Unknown.gif");
                }
            }
            if (icon != null) {
                if (this.m_ScaleFactor != 1.0) {
                    icon = new ImageIcon(icon.getImage().getScaledInstance((int)((double)icon.getIconWidth() * this.m_ScaleFactor), (int)((double)icon.getIconHeight() * this.m_ScaleFactor), 4));
                }
                this.m_Icons.put(classname, icon);
            }
        }
        if (icon != null) {
            result = new ActorIcon(icon, execution, actor.getDebugLevel() > 0, ActorUtils.isSink(actor) || ActorUtils.isTransformer(actor), ActorUtils.isSource(actor) || ActorUtils.isTransformer(actor), ActorUtils.isActorHandler(actor), ActorUtils.isActorHandler(actor) ? ((ActorHandler)((Object)actor)).getActorHandlerInfo().getForwardsInput() : false, actor.getClass().getAnnotation(Deprecated.class) != null);
        }
        return result;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ActorIcon icon = null;
        if (value instanceof Node) {
            Node pNode = (Node)((Node)value).getParent();
            AbstractActor parent = null;
            if (pNode != null) {
                parent = pNode.getActor();
            }
            if ((icon = this.getIcon(parent, ((Node)value).getActor(), !expanded && !leaf)) != null) {
                if (tree.isEditable() && tree.isEnabled()) {
                    this.setIcon(icon);
                } else if (!tree.isEditable()) {
                    icon = new DisabledIcon(icon);
                    this.setIcon(icon);
                } else if (!tree.isEnabled()) {
                    icon = new DisabledIcon(icon);
                    this.setDisabledIcon(icon);
                }
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }
        }
        return this;
    }

    public static class DisabledIcon
    extends ActorIcon {
        public DisabledIcon(ActorIcon icon) {
            this(icon.getIcon(), icon.getExecution(), icon.getDebugOn(), icon.hasInput(), icon.hasOutput(), icon.hasSubActors(), icon.getForwardsInput(), icon.isDeprecated());
        }

        public DisabledIcon(ImageIcon icon, ActorExecution execution, boolean debugOn, boolean hasInput, boolean hasOutput, boolean hasSubActors, boolean forwardsInput, boolean deprecated) {
            super(icon, execution, debugOn, hasInput, hasOutput, hasSubActors, forwardsInput, deprecated);
        }

        protected void paintBackground(Graphics g, int x, int y, int w, int h) {
            if (this.m_DebugOn) {
                g.setColor(BACKGROUND_RUNNING_DEBUG);
            } else {
                g.setColor(BACKGROUND_RUNNING);
            }
            g.fillRect(x + 1, y + 1, w - 2, h - 2);
        }
    }

    public static class ActorIcon
    implements Icon {
        protected ImageIcon m_Icon;
        protected ActorExecution m_Execution;
        protected boolean m_DebugOn;
        protected boolean m_HasInput;
        protected boolean m_HasOutput;
        protected boolean m_HasSubActors;
        protected boolean m_ForwardsInput;
        protected boolean m_Deprecated;

        public ActorIcon(ImageIcon icon, ActorExecution execution, boolean debugOn, boolean hasInput, boolean hasOutput, boolean hasSubActors, boolean forwardsInput, boolean deprecated) {
            this.m_Icon = icon;
            this.m_Execution = execution;
            this.m_DebugOn = debugOn;
            this.m_HasInput = hasInput;
            this.m_HasOutput = hasOutput;
            this.m_HasSubActors = hasSubActors;
            this.m_ForwardsInput = forwardsInput;
            this.m_Deprecated = deprecated;
        }

        protected void paintBackground(Graphics g, int x, int y, int w, int h) {
            if (this.m_DebugOn) {
                g.setColor(BACKGROUND_EDITING_DEBUG);
                g.fillRect(x + 1, y + 1, w - 2, h - 2);
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.m_Icon == null) {
                return;
            }
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            this.paintBackground(g, x, y, w, h);
            g.setColor(COLOR_VISUALCUES);
            if (this.m_HasSubActors && this.m_HasInput && this.m_ForwardsInput) {
                g.drawLine(x + w, y + h / 2, x + w + 3, y + h / 2);
            }
            if (this.m_Execution != ActorExecution.UNDEFINED) {
                switch (this.m_Execution) {
                    case SEQUENTIAL: {
                        if (this.m_HasInput) {
                            g.drawLine(x + w / 2, y, x + w / 2, 0);
                        }
                        if (!this.m_HasOutput) break;
                        g.drawLine(x + w / 2, y + h, x + w / 2, c.getPreferredSize().height - 1);
                        break;
                    }
                    case PARALLEL: {
                        if (this.m_HasInput) {
                            g.drawLine(x - 3, y + h / 2, x, y + h / 2);
                        }
                        if (!this.m_HasOutput) break;
                        g.drawLine(x + w, y + h / 2, x + w + 3, y + h / 2);
                    }
                }
            }
            this.m_Icon.paintIcon(c, g, x, y);
            if (this.m_Deprecated) {
                g.setColor(COLOR_DEPRECATED);
                g.drawLine(x, y, x + w, y + h);
                g.drawLine(x, y + h, x + w, y);
            }
        }

        public ImageIcon getIcon() {
            return this.m_Icon;
        }

        public void setExecution(ActorExecution value) {
            this.m_Execution = value;
        }

        public ActorExecution getExecution() {
            return this.m_Execution;
        }

        public boolean getDebugOn() {
            return this.m_DebugOn;
        }

        public boolean hasInput() {
            return this.m_HasInput;
        }

        public boolean hasOutput() {
            return this.m_HasOutput;
        }

        public boolean hasSubActors() {
            return this.m_HasSubActors;
        }

        public boolean getForwardsInput() {
            return this.m_ForwardsInput;
        }

        public boolean isDeprecated() {
            return this.m_Deprecated;
        }

        public int getIconWidth() {
            if (this.m_Icon == null) {
                return 0;
            }
            return this.m_Icon.getIconWidth();
        }

        public int getIconHeight() {
            if (this.m_Icon == null) {
                return 0;
            }
            return this.m_Icon.getIconHeight();
        }

        public String toString() {
            return "execution=" + (Object)((Object)this.m_Execution) + ", input=" + this.m_HasInput + ", output=" + this.m_HasOutput;
        }
    }
}

