/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.AbstractOption;
import adams.gui.chooser.FontChooserPanel;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FontEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    public static final String PLAIN = "PLAIN";
    public static final String BOLD = "BOLD";
    public static final String ITALIC = "ITALIC";
    public static final char SEPARATOR = '-';
    protected FontChooserPanel m_FontChooserPanel;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonClose;

    public static String toString(AbstractOption option, Object object) {
        Font font = (Font)object;
        String result = font.getName();
        result = result + '-' + (font.isBold() ? BOLD : PLAIN);
        if (font.isItalic()) {
            result = result + ",ITALIC";
        }
        result = result + "-" + font.getSize();
        return result;
    }

    public static Object valueOf(AbstractOption option, String str) {
        int atts;
        int size = Integer.parseInt(str.substring(str.lastIndexOf(45) + 1));
        str = str.substring(0, str.lastIndexOf(45));
        String attsStr = str.substring(str.lastIndexOf(45) + 1);
        str = str.substring(0, str.lastIndexOf(45));
        int n = atts = attsStr.indexOf(BOLD) > -1 ? 1 : 0;
        if (attsStr.indexOf(ITALIC) > -1) {
            atts |= 2;
        }
        String name = str;
        Font result = new Font(name, atts, size);
        return result;
    }

    public String toCustomStringRepresentation(Object obj) {
        return FontEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return FontEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        return "null";
    }

    protected JComponent createCustomEditor() {
        Font currentFont = (Font)this.getValue();
        this.m_FontChooserPanel = new FontChooserPanel();
        this.m_FontChooserPanel.setCurrent(currentFont);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_FontChooserPanel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontEditor.this.setValue(FontEditor.this.m_FontChooserPanel.getCurrent());
                FontEditor.this.closeDialog();
            }
        });
        panelButtons.add(this.m_ButtonOK);
        this.m_ButtonClose = new JButton("Cancel");
        this.m_ButtonClose.setMnemonic('C');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontEditor.this.m_FontChooserPanel.setCurrent((Font)FontEditor.this.getValue());
                FontEditor.this.closeDialog();
            }
        });
        panelButtons.add(this.m_ButtonClose);
        return panel;
    }

    protected void initForDisplay() {
        Font currentFont = (Font)this.getValue();
        if (currentFont != null) {
            this.m_FontChooserPanel.setCurrent(currentFont);
        }
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        Font font = (Font)this.getValue();
        String val = "No font";
        if (font != null) {
            val = FontEditor.toString(null, font);
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

