/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class PlaceholderFileEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((PlaceholderFile)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new PlaceholderFile(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return PlaceholderFileEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return PlaceholderFileEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        PlaceholderFile f = (PlaceholderFile)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new adams.core.io.PlaceholderFile(\"" + f.getName() + "\")";
    }

    protected JComponent createCustomEditor() {
        PlaceholderFile currentFile = (PlaceholderFile)this.getValue();
        this.m_FileChooser = currentFile != null ? new BaseFileChooser() : new BaseFileChooser(new PlaceholderFile(System.getProperty("user.dir")));
        this.m_FileChooser.setApproveButtonText("Select");
        this.m_FileChooser.setApproveButtonMnemonic('S');
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_FileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    PlaceholderFile newVal = PlaceholderFileEditor.this.m_FileChooser.getSelectedPlaceholderFile();
                    PlaceholderFileEditor.this.setValue(newVal);
                }
                PlaceholderFileEditor.this.closeDialog();
            }
        });
        return this.m_FileChooser;
    }

    protected void initForDisplay() {
        PlaceholderFile currentFile = (PlaceholderFile)this.getValue();
        if (currentFile != null) {
            this.m_FileChooser.setSelectedFile(currentFile);
        }
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        PlaceholderFile f = (PlaceholderFile)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

