/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class PostscriptGraphics
extends Graphics2D {
    protected Rectangle m_extent;
    protected PrintStream m_printstream;
    protected GraphicsState m_psGraphicsState;
    protected GraphicsState m_localGraphicsState;
    protected static final boolean DEBUG = false;
    protected static Hashtable m_PSFontReplacement = new Hashtable();

    public PostscriptGraphics(int width, int height, OutputStream os) {
        this.m_extent = new Rectangle(0, 0, height, width);
        this.m_printstream = new PrintStream(os);
        this.m_localGraphicsState = new GraphicsState();
        this.m_psGraphicsState = new GraphicsState();
        this.Header();
    }

    PostscriptGraphics(PostscriptGraphics copy) {
        this.m_extent = new Rectangle(copy.m_extent);
        this.m_printstream = copy.m_printstream;
        this.m_localGraphicsState = new GraphicsState(copy.m_localGraphicsState);
        this.m_psGraphicsState = copy.m_psGraphicsState;
    }

    public void finished() {
        this.m_printstream.flush();
    }

    private void Header() {
        this.m_printstream.println("%!PS-Adobe-3.0 EPSF-3.0");
        this.m_printstream.println("%%BoundingBox: 0 0 " + this.xScale(this.m_extent.width) + " " + this.yScale(this.m_extent.height));
        this.m_printstream.println("%%CreationDate: " + Calendar.getInstance().getTime());
        this.m_printstream.println("/Oval { % x y w h filled");
        this.m_printstream.println("gsave");
        this.m_printstream.println("/filled exch def /h exch def /w exch def /y exch def /x exch def");
        this.m_printstream.println("x w 2 div add y h 2 div sub translate");
        this.m_printstream.println("1 h w div scale");
        this.m_printstream.println("filled {0 0 moveto} if");
        this.m_printstream.println("0 0 w 2 div 0 360 arc");
        this.m_printstream.println("filled {closepath fill} {stroke} ifelse grestore} bind def");
        this.m_printstream.println("/Rect { % x y w h filled");
        this.m_printstream.println("/filled exch def /h exch def /w exch def /y exch def /x exch def");
        this.m_printstream.println("newpath ");
        this.m_printstream.println("x y moveto");
        this.m_printstream.println("w 0 rlineto");
        this.m_printstream.println("0 h neg rlineto");
        this.m_printstream.println("w neg 0 rlineto");
        this.m_printstream.println("closepath");
        this.m_printstream.println("filled {fill} {stroke} ifelse} bind def");
        this.m_printstream.println("%%BeginProlog\n%%EndProlog");
        this.m_printstream.println("%%Page 1 1");
        this.setFont(null);
        this.setColor(null);
        this.setStroke(null);
    }

    public static void addPSFontReplacement(String replace, String with) {
        m_PSFontReplacement.put(replace, with);
    }

    private int yTransform(int y) {
        return this.m_extent.height - (this.m_localGraphicsState.getYOffset() + y);
    }

    private int xTransform(int x) {
        return this.m_localGraphicsState.getXOffset() + x;
    }

    private int doScale(int number, double factor) {
        return (int)StrictMath.round((double)number * factor);
    }

    private int xScale(int x) {
        return this.doScale(x, this.m_localGraphicsState.getXScale());
    }

    private int yScale(int y) {
        return this.doScale(y, this.m_localGraphicsState.getYScale());
    }

    private void setStateToLocal() {
        this.setColor(this.getColor());
        this.setFont(this.getFont());
        this.setStroke(this.getStroke());
    }

    private String toHex(int i) {
        String result = Integer.toHexString(i);
        if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.setStateToLocal();
        Color saveColor = this.getColor();
        this.setColor(Color.white);
        this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " " + this.xScale(width) + " " + this.yScale(height) + " true Rect");
        this.setColor(saveColor);
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        PostscriptGraphics psg = new PostscriptGraphics(this);
        return psg;
    }

    public void dispose() {
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.drawRect(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, Color.WHITE, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        try {
            int[] pixels = new int[width * height];
            PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
            grabber.grabPixels();
            ColorModel model = ColorModel.getRGBdefault();
            this.m_printstream.println("gsave");
            this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + (this.yTransform(this.yScale(y)) - this.yScale(height)) + " translate");
            this.m_printstream.println(this.xScale(width) + " " + this.yScale(height) + " scale");
            this.m_printstream.println(width + " " + height + " " + "8" + " [" + width + " 0 0 " + -height + " 0 " + height + "]");
            this.m_printstream.println("{<");
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int index = i * width + j;
                    this.m_printstream.print(this.toHex(model.getRed(pixels[index])));
                    this.m_printstream.print(this.toHex(model.getGreen(pixels[index])));
                    this.m_printstream.print(this.toHex(model.getBlue(pixels[index])));
                }
                this.m_printstream.println();
            }
            this.m_printstream.println(">}");
            this.m_printstream.println("false 3 colorimage");
            this.m_printstream.println("grestore");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, Color.WHITE, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, Color.WHITE, observer);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(x1)) + " " + this.yTransform(this.yScale(y1)) + " moveto " + this.xTransform(this.xScale(x2)) + " " + this.yTransform(this.yScale(y2)) + " lineto stroke");
    }

    public void drawOval(int x, int y, int width, int height) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " " + this.xScale(width) + " " + this.yScale(height) + " false Oval");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawRect(int x, int y, int width, int height) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " " + this.xScale(width) + " " + this.yScale(height) + " false Rect");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    protected String escape(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '(' || s.charAt(i) == ')') {
                result.append('\\');
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public void drawString(String str, int x, int y) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " moveto" + " (" + this.escape(str) + ") show stroke");
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.fillRect(x, y, width, height);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    public void fillOval(int x, int y, int width, int height) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " " + this.xScale(width) + " " + this.yScale(height) + " true Oval");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void fillPolygon(Polygon p) {
    }

    public void fillRect(int x, int y, int width, int height) {
        if (width == this.m_extent.width && height == this.m_extent.height) {
            this.clearRect(x, y, width, height);
        } else {
            this.setStateToLocal();
            this.m_printstream.println(this.xTransform(this.xScale(x)) + " " + this.yTransform(this.yScale(y)) + " " + this.xScale(width) + " " + this.yScale(height) + " true Rect");
        }
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void finalize() {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return new Rectangle(0, 0, this.m_extent.width, this.m_extent.height);
    }

    public Rectangle getClipBounds(Rectangle r) {
        r.setBounds(0, 0, this.m_extent.width, this.m_extent.height);
        return r;
    }

    public Rectangle getClipRect() {
        return null;
    }

    public Color getColor() {
        return this.m_localGraphicsState.getColor();
    }

    public Font getFont() {
        return this.m_localGraphicsState.getFont();
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public void setClip(Shape clip) {
    }

    public void setColor(Color c) {
        if (c != null) {
            this.m_localGraphicsState.setColor(c);
            if (this.m_psGraphicsState.getColor().equals(c)) {
                return;
            }
            this.m_psGraphicsState.setColor(c);
        } else {
            this.m_localGraphicsState.setColor(Color.black);
            this.m_psGraphicsState.setColor(this.getColor());
        }
        this.m_printstream.print((double)this.getColor().getRed() / 255.0);
        this.m_printstream.print(" ");
        this.m_printstream.print((double)this.getColor().getGreen() / 255.0);
        this.m_printstream.print(" ");
        this.m_printstream.print((double)this.getColor().getBlue() / 255.0);
        this.m_printstream.println(" setrgbcolor");
    }

    private static String replacePSFont(String font) {
        String result = font;
        if (m_PSFontReplacement.containsKey(font)) {
            result = m_PSFontReplacement.get(font).toString();
        }
        return result;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.m_localGraphicsState.setFont(font);
            if (font.getName().equals(this.m_psGraphicsState.getFont().getName()) && this.m_psGraphicsState.getFont().getStyle() == font.getStyle() && this.m_psGraphicsState.getFont().getSize() == this.yScale(font.getSize())) {
                return;
            }
            this.m_psGraphicsState.setFont(new Font(font.getName(), font.getStyle(), this.yScale(this.getFont().getSize())));
        } else {
            this.m_localGraphicsState.setFont(new Font("Courier", 0, 11));
            this.m_psGraphicsState.setFont(this.getFont());
        }
        this.m_printstream.println("/(" + PostscriptGraphics.replacePSFont(this.getFont().getPSName()) + ")" + " findfont");
        this.m_printstream.println(this.yScale(this.getFont().getSize()) + " scalefont setfont");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void translate(int x, int y) {
        this.m_localGraphicsState.setXOffset(this.m_localGraphicsState.getXOffset() + this.xScale(x));
        this.m_localGraphicsState.setYOffset(this.m_localGraphicsState.getYOffset() + this.yScale(y));
        this.m_psGraphicsState.setXOffset(this.m_psGraphicsState.getXOffset() + this.xScale(x));
        this.m_psGraphicsState.setYOffset(this.m_psGraphicsState.getYOffset() + this.yScale(y));
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, true, true);
    }

    public void clip(Shape s) {
    }

    public Stroke getStroke() {
        return this.m_localGraphicsState.getStroke();
    }

    public Color getBackground() {
        return Color.white;
    }

    public void setBackground(Color c) {
    }

    public Composite getComposite() {
        return AlphaComposite.getInstance(2);
    }

    public Paint getPaint() {
        return new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue());
    }

    public AffineTransform getTransform() {
        return new AffineTransform();
    }

    public void setTransform(AffineTransform at) {
    }

    public void transform(AffineTransform at) {
    }

    public void shear(double d1, double d2) {
    }

    public void scale(double d1, double d2) {
        this.m_localGraphicsState.setXScale(d1);
        this.m_localGraphicsState.setYScale(d2);
    }

    public void rotate(double d1, double d2, double d3) {
    }

    public void rotate(double d1) {
    }

    public void translate(double d1, double d2) {
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    public void addRenderingHints(Map m) {
    }

    public void setRenderingHints(Map m) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object o) {
    }

    public void setStroke(Stroke s) {
        if (s != null) {
            this.m_localGraphicsState.setStroke(s);
            if (s.equals(this.m_psGraphicsState.getStroke())) {
                return;
            }
            this.m_psGraphicsState.setStroke(s);
        } else {
            this.m_localGraphicsState.setStroke(new BasicStroke());
            this.m_psGraphicsState.setStroke(this.getStroke());
        }
    }

    public void setPaint(Paint p) {
    }

    public void setComposite(Composite c) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public boolean hit(Rectangle r, Shape s, boolean onstroke) {
        return false;
    }

    public void fill(Shape s) {
    }

    public void drawGlyphVector(GlyphVector gv, float f1, float f2) {
    }

    public void drawString(AttributedCharacterIterator aci, float f1, float f2) {
    }

    public void drawString(String str, float x, float y) {
        this.drawString(str, (int)x, (int)y);
    }

    public void drawRenderableImage(RenderableImage ri, AffineTransform at) {
    }

    public void drawRenderedImage(RenderedImage ri, AffineTransform af) {
    }

    public void drawImage(BufferedImage bi, BufferedImageOp bio, int i1, int i2) {
    }

    public boolean drawImage(Image im, AffineTransform at, ImageObserver io) {
        return false;
    }

    public void draw(Shape s) {
    }

    static {
        m_PSFontReplacement.put("SansSerif.plain", "Helvetica.plain");
        m_PSFontReplacement.put("Dialog.plain", "Helvetica.plain");
        m_PSFontReplacement.put("Microsoft Sans Serif", "Helvetica.plain");
        m_PSFontReplacement.put("MicrosoftSansSerif", "Helvetica.plain");
    }

    private class GraphicsState {
        protected Color m_currentColor;
        protected Font m_currentFont;
        protected Stroke m_currentStroke;
        protected int m_xOffset;
        protected int m_yOffset;
        protected double m_xScale;
        protected double m_yScale;

        GraphicsState() {
            this.m_currentColor = Color.white;
            this.m_currentFont = new Font("Courier", 0, 11);
            this.m_currentStroke = new BasicStroke();
            this.m_xOffset = 0;
            this.m_yOffset = 0;
            this.m_xScale = 1.0;
            this.m_yScale = 1.0;
        }

        GraphicsState(GraphicsState copy) {
            this.m_currentColor = copy.m_currentColor;
            this.m_currentFont = copy.m_currentFont;
            this.m_currentStroke = copy.m_currentStroke;
            this.m_xOffset = copy.m_xOffset;
            this.m_yOffset = copy.m_yOffset;
            this.m_xScale = copy.m_xScale;
            this.m_yScale = copy.m_yScale;
        }

        protected Stroke getStroke() {
            return this.m_currentStroke;
        }

        protected void setStroke(Stroke s) {
            this.m_currentStroke = s;
        }

        protected Font getFont() {
            return this.m_currentFont;
        }

        protected void setFont(Font f) {
            this.m_currentFont = f;
        }

        protected Color getColor() {
            return this.m_currentColor;
        }

        protected void setColor(Color c) {
            this.m_currentColor = c;
        }

        protected void setXOffset(int xo) {
            this.m_xOffset = xo;
        }

        protected void setYOffset(int yo) {
            this.m_yOffset = yo;
        }

        protected int getXOffset() {
            return this.m_xOffset;
        }

        protected int getYOffset() {
            return this.m_yOffset;
        }

        protected void setXScale(double x) {
            this.m_xScale = x;
        }

        protected void setYScale(double y) {
            this.m_yScale = y;
        }

        protected double getXScale() {
            return this.m_xScale;
        }

        protected double getYScale() {
            return this.m_yScale;
        }
    }
}

