/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.scripting.AbstractScriptingEngine;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingEngineManager
implements Serializable {
    private static final long serialVersionUID = 739416057351690903L;
    protected Hashtable<String, AbstractScriptingEngine> m_Engines = new Hashtable();

    public boolean has(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.containsKey(dbcon.getURL());
    }

    public AbstractScriptingEngine get(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.get(dbcon.getURL());
    }

    public AbstractScriptingEngine add(AbstractDatabaseConnection dbcon, AbstractScriptingEngine engine) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.put(dbcon.getURL(), engine);
    }

    public Iterator<AbstractScriptingEngine> iterator() {
        return this.m_Engines.values().iterator();
    }

    public String toString() {
        return "Scripting engines: " + this.m_Engines.keySet();
    }
}

