/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.visualization.container.ContainerManager;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
implements Serializable,
Comparable<Container> {
    private static final long serialVersionUID = 8203562082477741415L;
    protected ContainerManager m_Manager;
    protected Comparable m_Payload;
    protected boolean m_Updating;

    public Container(ContainerManager manager, Comparable payload) {
        this.setManager(manager);
        this.setPayload(payload);
        this.initialize();
    }

    protected void initialize() {
        this.m_Updating = false;
    }

    protected void invalidate() {
    }

    public void setManager(ContainerManager value) {
        this.m_Manager = value;
    }

    public ContainerManager getManager() {
        return this.m_Manager;
    }

    public void setPayload(Comparable value) {
        this.invalidate();
        this.m_Payload = value;
        this.postProcessPayload();
    }

    protected void postProcessPayload() {
    }

    public Comparable getPayload() {
        return this.m_Payload;
    }

    public void assign(Container c) {
        this.m_Updating = true;
        this.setPayload(c.getPayload());
        this.m_Updating = false;
    }

    public Container copy() {
        Container result;
        if (this.getManager() != null) {
            result = (Container)this.getManager().newContainer(this.getPayload());
            result.assign(this);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public int compareTo(Container o) {
        if (o == null) {
            return 1;
        }
        if (this.getPayload() == null || o.getPayload() == null) {
            if (this.getPayload() == null && o.getPayload() == null) {
                return 0;
            }
            if (this.getPayload() == null) {
                return -1;
            }
            return 1;
        }
        return this.getPayload().compareTo(o.getPayload());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Container)) {
            return false;
        }
        return this.compareTo((Container)o) == 0;
    }

    public String toString() {
        return "" + this.m_Payload;
    }
}

