/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.gui.visualization.core.axis.AbsoluteAxisModel;
import adams.gui.visualization.core.axis.AbstractAxisModel;
import adams.gui.visualization.core.axis.DateAxisModel;
import adams.gui.visualization.core.axis.DateTimeAxisModel;
import adams.gui.visualization.core.axis.Log10AbsoluteAxisModel;
import adams.gui.visualization.core.axis.Log10PercentageAxisModel;
import adams.gui.visualization.core.axis.LogAbsoluteAxisModel;
import adams.gui.visualization.core.axis.LogPercentageAxisModel;
import adams.gui.visualization.core.axis.PercentageAxisModel;
import adams.gui.visualization.core.axis.TimeAxisModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Type implements EnumWithCustomDisplay<Type>
{
    ABSOLUTE(AbsoluteAxisModel.class),
    PERCENTAGE(PercentageAxisModel.class),
    LOG10_ABSOLUTE(Log10AbsoluteAxisModel.class),
    LOG10_PERCENTAGE(Log10PercentageAxisModel.class),
    LOG_ABSOLUTE(LogAbsoluteAxisModel.class),
    LOG_PERCENTAGE(LogPercentageAxisModel.class),
    DATE(DateAxisModel.class),
    TIME(TimeAxisModel.class),
    DATETIME(DateTimeAxisModel.class);

    private String m_Display;
    private String m_Raw;
    private Class m_AxisModelClass;

    private Type(Class cls) {
        this.m_AxisModelClass = cls;
        this.m_Display = this.getModel().getDisplayName();
        this.m_Raw = super.toString();
    }

    @Override
    public String toDisplay() {
        return this.m_Display;
    }

    @Override
    public String toRaw() {
        return this.m_Raw;
    }

    public AbstractAxisModel getModel() {
        AbstractAxisModel result;
        try {
            result = (AbstractAxisModel)this.m_AxisModelClass.newInstance();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public boolean canHandle(double min, double max) {
        boolean result = false;
        AbstractAxisModel model = this.getModel();
        if (model != null) {
            result = model.canHandle(min, max);
        }
        return result;
    }

    public String toString() {
        return this.m_Display;
    }

    @Override
    public Type parse(String s) {
        return Type.valueOf((AbstractOption)null, s);
    }

    public static String toString(AbstractOption option, Object object) {
        return ((Type)object).toRaw();
    }

    public static Type valueOf(AbstractOption option, String str) {
        Type result = null;
        try {
            result = Type.valueOf(str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            for (Type f : Type.values()) {
                if (!f.toDisplay().equals(str)) continue;
                result = f;
                break;
            }
        }
        return result;
    }
}

