/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.parser.AbstractSymbolEvaluator;
import adams.parser.mathematicalexpression.Parser;
import adams.parser.mathematicalexpression.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathematicalExpression
extends AbstractSymbolEvaluator<Double> {
    private static final long serialVersionUID = 8014316012335802585L;

    @Override
    public String globalInfo() {
        return "Evaluates mathematical expressions.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return "expr_list ::= expr_list expr_part | expr_part ;\nexpr_part ::= expr ;\n\nnumexpr   ::=   ( numexpr )\n              |  NUMBER\n              | -numexpr\n              | constexpr\n              | opexpr\n              | varexpr\n              | funcexpr\n              ;\n\nconstexpr ::=   PI\n              | E\n              ;\n\nopexpr    ::=   numexpr + numexpr\n              | numexpr - numexpr\n              | numexpr * numexpr\n              | numexpr / numexpr\n              | numexpr ^ numexpr\n              ;\n\nvarexpr  ::=  VARIABLE ;\n\nfuncexpr ::=    abs ( numexpr )\n              | sqrt ( numexpr )\n              | log ( numexpr )\n              | exp ( numexpr )\n              | sin ( numexpr )\n              | cos ( numexpr )\n              | tan ( numexpr )\n              | rint ( numexpr )\n              | floor ( numexpr )\n              | pow ( numexpr , numexpr )\n              | ceil ( numexpr )\n              | ifelse ( boolexpr , numexpr (if true) , numexpr (if false) )\n              ;\n\nboolexpr ::=    BOOLEAN\n              | true\n              | false\n              | numexpr &lt; numexpr\n              | numexpr &lt;= numexpr\n              | numexpr &gt; numexpr\n              | numexpr &gt;= numexpr\n              | numexpr = numexpr\n              | numexpr != numexpr\n              | ( boolexpr )\n              | ! boolexpr\n              | boolexpr & boolexpr\n              | boolexpr | boolexpr\n              ;\n\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "42";
    }

    @Override
    public String expressionTipText() {
        return "The mathematical expression to evaluate (must evaluate to a double).";
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getSystemErr().println("Failed to parse the value of symbol '" + name + "': " + value);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    protected Double doEvaluate(HashMap symbols) throws Exception {
        return MathematicalExpression.evaluate(this.m_Expression, symbols);
    }

    public static double evaluate(String expr, HashMap symbols) throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        MathematicalExpression.runEvaluator(MathematicalExpression.class, args);
    }
}

