/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;

public abstract class AbstractTool
extends OptionHandlingObject
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 8248797808829239144L;

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine((AbstractTool)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    protected void preRun() {
    }

    protected abstract void doRun();

    protected void postRun() {
    }

    public void cleanUp() {
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public void run() {
        this.preRun();
        this.doRun();
        this.postRun();
        this.cleanUp();
    }

    public static String[] getTools() {
        return ClassLister.getSingleton().getClassnames(AbstractTool.class);
    }

    public static AbstractTool forName(String classname, String[] options) {
        AbstractTool result;
        try {
            result = (AbstractTool)OptionUtils.forName(AbstractTool.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractTool forCommandLine(String cmdline) {
        return (AbstractTool)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

