/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -1662519690087375313L;

    public SerialClob(char[] cArray) throws SerialException, SQLException {
        this.len = cArray.length;
        this.buf = new char[(int)this.len];
        int n = 0;
        while ((long)n < this.len) {
            this.buf[n] = cArray[n];
            ++n;
        }
        this.origLen = this.len;
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a SerialClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int n = 0;
        int n2 = 0;
        if (clob.getCharacterStream() == null || clob.getAsciiStream() == null) {
            throw new SQLException("Invalid Clob object. Calls to getCharacterStream and getAsciiStream return null which cannot be serialized.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
            do {
                n = bufferedReader.read(this.buf, n2, (int)(this.len - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SerialException("SerialClob: " + iOException.getMessage());
        }
        this.origLen = this.len;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public Reader getCharacterStream() throws SerialException {
        return new CharArrayReader(this.buf);
    }

    public InputStream getAsciiStream() throws SerialException, SQLException {
        if (this.clob != null) {
            return this.clob.getAsciiStream();
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a the CLOB value as an ascii stream, unless instantiated with a fully implemented Clob object.");
    }

    public String getSubString(long l, int n) throws SerialException {
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if (l - 1L + (long)n > this.length()) {
            throw new SerialException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)l - 1, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SerialException("StringIndexOutOfBoundsException: " + stringIndexOutOfBoundsException.getMessage());
        }
    }

    public long position(String string, long l) throws SerialException, SQLException {
        if (l < 1L || l > this.len) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n = (int)l - 1;
        int n2 = 0;
        long l2 = cArray.length;
        while ((long)n < this.len) {
            if (cArray[n2] == this.buf[n]) {
                if ((long)(n2 + 1) == l2) {
                    return (long)(n + 1) - (l2 - 1L);
                }
                ++n2;
                ++n;
                continue;
            }
            if (cArray[n2] == this.buf[n]) continue;
            ++n;
        }
        return -1L;
    }

    public long position(Clob clob, long l) throws SerialException, SQLException {
        char[] cArray = null;
        try {
            Reader reader = clob.getCharacterStream();
            cArray = new char[(int)clob.length()];
            reader.read(cArray);
        }
        catch (IOException iOException) {
            throw new SerialException("Error streaming Clob search data");
        }
        return this.position(new String(cArray), l);
    }

    public int setString(long l, String string) throws SerialException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SerialException {
        int n3;
        String string2 = string.substring(n);
        char[] cArray = string2.toCharArray();
        if (n < 0 || n > string.length()) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n2 + n > string.length()) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Blob buffer");
        }
        --l;
        for (n3 = 0; n3 < n2 || n + n3 + 1 < string.length() - n; ++n3) {
            this.buf[(int)l + n3] = cArray[n + n3];
        }
        return n3;
    }

    public OutputStream setAsciiStream(long l) throws SerialException, SQLException {
        if (this.clob.setAsciiStream(l) != null) {
            return this.clob.setAsciiStream(l);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable ascii stream\n unless instantiated with a Clob object that has a setAsciiStream() implementation");
    }

    public Writer setCharacterStream(long l) throws SerialException, SQLException {
        if (this.clob.setCharacterStream(l) != null) {
            return this.clob.setCharacterStream(l);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable character stream\n unless instantiated with a Clob object that has a setCharacterStream implementation");
    }

    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = l;
        this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
    }
}

