/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.db.AbstractDatabaseConnection;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.standalone.DatabaseConnection;
import adams.gui.core.BasePanel;
import adams.gui.core.SearchPanel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.report.ReportContainer;
import adams.gui.visualization.report.ReportContainerManager;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ExpDBReporter
extends AbstractTextualDisplay {
    private static final long serialVersionUID = 934663436062863370L;
    protected ReportContainerManager m_Manager;
    protected ReportFactory.Panel m_Panel;
    protected SearchPanel m_SearchPanel;
    protected boolean m_ReportSelected;

    public String globalInfo() {
        return "Displays reports.";
    }

    protected int getDefaultWidth() {
        return 450;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void clearPanel() {
        this.m_Manager.clear();
        this.m_Panel.setData(new Vector());
        this.m_ReportSelected = false;
    }

    protected BasePanel newPanel() {
        this.m_Manager = new ReportContainerManager(ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton()));
        this.m_Panel = ReportFactory.getPanel(new Vector());
        this.m_Panel.setDividerLocation((int)((double)this.getWidth() * 0.67));
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)this.m_Panel, (Object)"Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                ExpDBReporter.this.m_Panel.search(ExpDBReporter.this.m_SearchPanel.getSearchText(), ExpDBReporter.this.m_SearchPanel.isRegularExpression());
                ExpDBReporter.this.m_SearchPanel.grabFocus();
            }
        });
        panel.add((Component)this.m_SearchPanel);
        result.add((Component)panel, (Object)"South");
        this.m_ReportSelected = false;
        return result;
    }

    protected String createTitle() {
        return "Report - " + this.getFullName();
    }

    public Class[] accepts() {
        return new Class[]{ReportHandler.class, Report.class};
    }

    protected void display(Token token) {
        Report report = token.getPayload() instanceof ReportHandler ? ((ReportHandler)token.getPayload()).getReport() : (Report)token.getPayload();
        if (report != null) {
            this.m_Manager.add((Container)this.m_Manager.newContainer((Comparable)report));
            this.m_Panel.setData(this.m_Manager.getAll());
        }
    }

    protected void postDisplay(Token token) {
        super.postDisplay(token);
        if (!this.m_ReportSelected) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ExpDBReporter.this.m_Panel.getContainerManager().count() > 0) {
                        ExpDBReporter.this.m_Panel.setCurrentTable(0);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected boolean supportsClear() {
        return true;
    }

    protected void clear() {
        this.m_Panel.removeAll();
    }

    public String supplyText() {
        Report report;
        String result = null;
        int index = this.m_Panel.getSelectedRow();
        if (index != -1 && (report = ((ReportContainer)this.m_Panel.getData().get(index)).getReport()) != null) {
            result = report.toProperties().toString();
        }
        return result;
    }
}

