/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimesScalarMatrix
implements TimesScalarCalculation<Matrix, Matrix> {
    TimesScalarMatrix() {
    }

    @Override
    public final void calc(Matrix source, BigDecimal factor, Matrix target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            TimesScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, factor, (DenseDoubleMatrix2D)target);
        } else if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            TimesScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, factor, (DenseMatrix2D)((DenseDoubleMatrix2D)target));
        } else if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            TimesScalar.DENSEMATRIX.calc((DenseMatrix)source, factor, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            TimesScalar.SPARSEMATRIX.calc((SparseMatrix)source, factor, (SparseMatrix)target);
        } else {
            VerifyUtil.assertSameSize(source, target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.times(value, factor);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(Matrix source, double factor, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            TimesScalar.DENSEMATRIX.calc((DenseMatrix)source, factor, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            TimesScalar.SPARSEMATRIX.calc((SparseMatrix)source, factor, (SparseMatrix)target);
        } else {
            this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
        }
    }
}

