/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.ujmp.gui.actions.PanelActions;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.jung.JungGraphPanel;

public class JungGraphActions
extends JPopupMenu {
    private static final long serialVersionUID = -2307893165969916295L;
    JungGraphPanel jungGraphPanel = null;
    public final Action frLayoutAction = new AbstractAction("FR Layout"){
        private static final long serialVersionUID = 3149916178777567323L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.switchLayout(JungGraphPanel.GraphLayout.FRLayout);
        }
    };
    public final Action iSomLayoutAction = new AbstractAction("ISOM Layout"){
        private static final long serialVersionUID = 1862486279803190687L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.switchLayout(JungGraphPanel.GraphLayout.ISOMLayout);
        }
    };
    public final Action kkLayoutAction = new AbstractAction("KK Layout"){
        private static final long serialVersionUID = 8756219332341323478L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.switchLayout(JungGraphPanel.GraphLayout.KKLayout);
        }
    };
    public final Action springLayoutAction = new AbstractAction("Spring Layout"){
        private static final long serialVersionUID = -9129746911116351142L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.switchLayout(JungGraphPanel.GraphLayout.SpringLayout);
        }
    };
    public final Action circleLayoutAction = new AbstractAction("Circle Layout"){
        private static final long serialVersionUID = -3030980988050670381L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.switchLayout(JungGraphPanel.GraphLayout.CircleLayout);
        }
    };
    public final Action refreshAction = new AbstractAction("Refresh"){
        private static final long serialVersionUID = -8057389215808050942L;

        public void actionPerformed(ActionEvent e) {
            GraphicsExecutor.scheduleUpdate(JungGraphActions.this.jungGraphPanel);
        }
    };
    public final Action exportToPdfAction = new AbstractAction("Export to PDF...", UIManager.getIcon("JDMP.icon.pdf")){
        private static final long serialVersionUID = -7413294854080175036L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.exportToPDF(ExportPDF.selectFile());
        }
    };
    public final Action exportToJpgAction = new AbstractAction("Export to JPG...", UIManager.getIcon("JDMP.icon.image")){
        private static final long serialVersionUID = 2903870037000412488L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.exportToJPEG(ExportJPEG.selectFile());
        }
    };
    public final Action toggleEdgesAction = new AbstractAction("Toggle Edges"){
        private static final long serialVersionUID = -7632767332831157590L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.setShowEdges(!JungGraphActions.this.jungGraphPanel.isShowEdges());
        }
    };
    public final Action toggleEdgeLabelsAction = new AbstractAction("Toggle Edge Labels"){
        private static final long serialVersionUID = 5043606502712307760L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.setShowEdgeLabels(!JungGraphActions.this.jungGraphPanel.isShowEdgeLabels());
        }
    };
    public final Action toggleVertexLabelsAction = new AbstractAction("Toggle Vertex Labels"){
        private static final long serialVersionUID = -8736147166116311565L;

        public void actionPerformed(ActionEvent e) {
            JungGraphActions.this.jungGraphPanel.setShowVertexLabels(!JungGraphActions.this.jungGraphPanel.isShowVertexLabels());
        }
    };

    public JungGraphActions(JungGraphPanel m) {
        this.jungGraphPanel = m;
        JMenu panelMenu = new JMenu("This Panel");
        for (JComponent c : new PanelActions((JComponent)((Object)m), null)) {
            panelMenu.add(c);
        }
        this.add(panelMenu);
        JMenu layoutMenu = new JMenu("Layout");
        layoutMenu.add(this.frLayoutAction);
        layoutMenu.add(this.kkLayoutAction);
        layoutMenu.add(this.iSomLayoutAction);
        layoutMenu.add(this.springLayoutAction);
        layoutMenu.add(this.circleLayoutAction);
        this.add(layoutMenu);
        this.add(this.toggleEdgesAction);
        this.add(this.toggleEdgeLabelsAction);
        this.add(this.toggleVertexLabelsAction);
        this.add(new JSeparator());
        this.add(this.exportToJpgAction);
        this.add(this.exportToPdfAction);
        this.add(new JSeparator());
        this.add(this.refreshAction);
    }
}

