/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.ClassLister;
import adams.core.io.SpreadSheet;
import adams.core.option.OptionHandlingObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.ReaderInputStream;

public abstract class AbstractSpreadSheetReader
extends OptionHandlingObject {
    private static final long serialVersionUID = 4828477005893179066L;
    protected String m_MissingValue;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("missing", "missingValue", "");
    }

    public abstract String getFormatDescription();

    public abstract String[] getFormatExtensions();

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values.";
    }

    protected abstract boolean getUseInputStream();

    public SpreadSheet read(File file) {
        return this.read(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpreadSheet read(String filename) {
        SpreadSheet result;
        BufferedReader reader = null;
        FileInputStream input = null;
        try {
            if (this.getUseInputStream()) {
                input = new FileInputStream(filename);
                result = this.doRead(input);
            } else {
                reader = new BufferedReader(new FileReader(filename));
                result = this.doRead(reader);
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public SpreadSheet read(InputStream stream) {
        SpreadSheet result;
        try {
            result = this.getUseInputStream() ? this.doRead(stream) : this.doRead(new BufferedReader(new InputStreamReader(stream)));
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public SpreadSheet read(Reader r) {
        SpreadSheet result;
        try {
            result = this.getUseInputStream() ? this.doRead((InputStream)new ReaderInputStream(r)) : this.doRead(r);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    protected SpreadSheet doRead(Reader r) {
        return null;
    }

    protected SpreadSheet doRead(InputStream in) {
        return null;
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(AbstractSpreadSheetReader.class);
    }
}

