/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFilter<T extends DataContainer>
extends AbstractDatabaseConnectionFilter<T> {
    private static final long serialVersionUID = 805661569976845842L;
    protected AbstractFilter<T>[] m_Filters;

    @Override
    public String globalInfo() {
        return "A meta-filter that runs multiple filters over the data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "subFilters", new AbstractFilter[]{new PassThrough()});
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public String subFiltersTipText() {
        return "The array of filters to use.";
    }

    public void setSubFilters(AbstractFilter<T>[] value) {
        if (value != null) {
            this.m_Filters = value;
            this.updateDatabaseConnection();
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": filters cannot be null!");
        }
    }

    public AbstractFilter<T>[] getSubFilters() {
        return this.m_Filters;
    }

    @Override
    protected void updateDatabaseConnection() {
        for (AbstractFilter<T> filter : this.m_Filters) {
            if (!(filter instanceof DatabaseConnectionHandler)) continue;
            ((DatabaseConnectionHandler)((Object)filter)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        T input = data;
        T output = data;
        for (int i = 0; i < this.m_Filters.length; ++i) {
            this.debug("Filter " + (i + 1) + "/" + this.m_Filters.length + ": " + OptionUtils.getCommandLine(this.m_Filters[i]));
            AbstractFilter<T> filter = this.m_Filters[i];
            output = filter.filter(input);
            filter.cleanUp();
            input = output;
        }
        this.debug("Finished!");
        DataContainer result = (DataContainer)output.getClone();
        return (T)result;
    }
}

