/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayRootRelativeSquaredError<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = 8850774453185677296L;

    @Override
    public String globalInfo() {
        return "Calculates the root relative squared error (RRSE) between the first array (actual) and the remaining arrays (predicted). The arrays must be numeric, of course.";
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 2;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size() - 1);
        for (int i = 1; i < this.size(); ++i) {
            result.setHeader(i - 1, "RRSE 1-" + (i + 1));
            result.setCell(0, i - 1, StatUtils.rrse((Number[])this.get(0), (Number[])this.get(i)));
        }
        return result;
    }
}

