/*
 * Decompiled with CFR 0.152.
 */
package adams.db.types;

public class SQL_type {
    public static final int MAX_VARCHAR = 255;
    public static final int MAX_TEXT = 65535;
    public static final int MAX_MEDIUMTEXT = 0xFFFFFF;
    protected int m_type = 0;
    protected int m_size = -1;

    public SQL_type(int sqlt) {
        this.m_type = sqlt;
    }

    public SQL_type(int sqlt, int size) {
        this.m_type = sqlt;
        if (sqlt == 12 || sqlt == -1) {
            this.m_size = size;
        }
    }

    public int getSize() {
        if (this.m_size != -1) {
            return this.m_size;
        }
        switch (this.m_type) {
            case -5: {
                return 20;
            }
            case 5: {
                return 6;
            }
            case 93: {
                return 14;
            }
            case 12: {
                if (this.m_size == -1) {
                    return 255;
                }
                if (this.m_size <= 255) {
                    return this.m_size;
                }
                if (this.m_size <= 65535) {
                    return 65535;
                }
                if (this.m_size <= 0xFFFFFF) {
                    return 0xFFFFFF;
                }
                return 0x1000000;
            }
            case -1: {
                if (this.m_size == -1) {
                    return 0xFFFFFF;
                }
                if (this.m_size <= 255) {
                    return this.m_size;
                }
                if (this.m_size <= 65535) {
                    return 65535;
                }
                if (this.m_size <= 0xFFFFFF) {
                    return 0xFFFFFF;
                }
                return 0x1000000;
            }
        }
        return -1;
    }

    public String getCompareType() {
        switch (this.m_type) {
            case -5: {
                return "BIGINT";
            }
            case 2004: {
                return "BLOB";
            }
            case -7: 
            case -6: 
            case 16: {
                return "TINYINT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: 
            case 7: {
                return "FLOAT";
            }
            case 5: {
                return "SMALLINT(" + this.getSize() + ")";
            }
            case 4: {
                return "INTEGER";
            }
            case -1: 
            case 12: {
                int s = this.getSize();
                if (s <= 255) {
                    return "VARCHAR(" + s + ")";
                }
                if (s <= 65535) {
                    return "TEXT";
                }
                if (s <= 0xFFFFFF) {
                    return "MEDIUMTEXT";
                }
                return "LONGTEXT";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case -4: {
                return "LONG VARBINARY";
            }
        }
        throw new IllegalStateException("No TYPE for " + this.m_type);
    }

    public boolean equivalentTo(SQL_type sqt) {
        return this.getCompareType().equals(sqt.getCompareType());
    }

    public String getCreateType() {
        String result = this.getCompareType();
        if (this.m_type == 93) {
            result = result + " NOT NULL DEFAULT '0000-00-00 00:00:00'";
        }
        return result;
    }

    public String toString() {
        return this.m_type + ": " + this.getCreateType();
    }
}

