/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.NamedSetup;
import adams.core.Pausable;
import adams.flow.core.AbstractActor;
import java.util.HashSet;

public abstract class AbstractNamedSetup
extends AbstractActor
implements Pausable {
    private static final long serialVersionUID = 1024129351334661368L;
    protected NamedSetup m_Setup;
    protected AbstractActor m_NamedSetupActor;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", new NamedSetup());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("setup");
        if (variable != null) {
            return variable;
        }
        return this.m_Setup.getName();
    }

    public void setSetup(NamedSetup value) {
        this.m_Setup = value;
        this.reset();
    }

    public NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The named setup to use.";
    }

    public AbstractActor getNamedSetupActor() {
        return this.m_NamedSetupActor;
    }

    protected String setUpNamedSetupActor() {
        String result = null;
        this.m_NamedSetupActor = (AbstractActor)this.m_Setup.getSetup();
        if (this.m_NamedSetupActor == null) {
            result = "Error retrieving named setup '" + this.m_Setup.getName() + "'!";
        } else {
            this.m_NamedSetupActor.setParent(this);
            this.m_NamedSetupActor.setHeadless(this.isHeadless());
            result = this.m_NamedSetupActor.setUp();
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_NamedSetupActor != null) {
                this.m_NamedSetupActor.wrapUp();
                this.m_NamedSetupActor.cleanUp();
                this.m_NamedSetupActor = null;
            }
            if (this.getOptionManager().getVariableForProperty("setup") == null && (result = this.setUpNamedSetupActor()) == null) {
                HashSet<String> variables = this.findVariables(this.m_NamedSetupActor);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
            }
        }
        return result;
    }

    public void pauseExecution() {
        if (this.m_NamedSetupActor != null && this.m_NamedSetupActor instanceof Pausable) {
            ((Pausable)((Object)this.m_NamedSetupActor)).pauseExecution();
        }
    }

    public boolean isPaused() {
        if (this.m_NamedSetupActor != null && this.m_NamedSetupActor instanceof Pausable) {
            return ((Pausable)((Object)this.m_NamedSetupActor)).isPaused();
        }
        return false;
    }

    public void resumeExecution() {
        if (this.m_NamedSetupActor != null && this.m_NamedSetupActor instanceof Pausable) {
            ((Pausable)((Object)this.m_NamedSetupActor)).resumeExecution();
        }
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_NamedSetupActor != null) {
            this.m_NamedSetupActor.stopExecution();
        }
    }

    protected String preExecuteNamedSetupActorHook() {
        return null;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_NamedSetupActor == null && (result = this.setUpNamedSetupActor()) == null) {
            HashSet<String> variables = this.findVariables(this.m_NamedSetupActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener(this);
            }
        }
        if (result == null) {
            result = this.preExecuteNamedSetupActorHook();
        }
        if (result == null) {
            result = this.m_NamedSetupActor.execute();
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_NamedSetupActor != null) {
            this.m_NamedSetupActor.wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_NamedSetupActor != null) {
            this.m_NamedSetupActor.destroy();
            this.m_NamedSetupActor.setParent(null);
            this.m_NamedSetupActor = null;
        }
        super.cleanUp();
    }
}

