/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomDouble;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class RandomNumberGenerator
extends AbstractSource {
    private static final long serialVersionUID = 6216146938771296415L;
    protected AbstractRandomNumberGenerator m_Generator;
    protected int m_MaxNum;
    protected int m_Count;

    public String globalInfo() {
        return "Random number generator. The type of random numbers depends on the chosen generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new JavaRandomDouble());
        this.m_OptionManager.add("max-num", "maxNum", 1000);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("generator");
        String result = variable != null ? variable : this.m_Generator.getClass().getName().replace("adams.data.random.", "");
        result = result + "/";
        variable = this.getOptionManager().getVariableForProperty("maxNum");
        result = variable != null ? result + variable : result + this.m_MaxNum;
        return result;
    }

    public void setGenerator(AbstractRandomNumberGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractRandomNumberGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The random number generator to use.";
    }

    public void setMaxNum(int value) {
        this.m_MaxNum = value;
        this.reset();
    }

    public int getMaxNum() {
        return this.m_MaxNum;
    }

    public String maxNumTipText() {
        return "The maximum number of random numbers to generate (-1 is unlimited).";
    }

    public Class[] generates() {
        return new Class[]{Double.class};
    }

    protected void reset() {
        super.reset();
        if (this.m_Generator != null) {
            this.m_Generator.reset();
        }
        this.m_Count = 0;
    }

    protected String doExecute() {
        return null;
    }

    public Token output() {
        ++this.m_Count;
        Token result = new Token(new Double(((Number)this.m_Generator.next()).doubleValue()));
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Executed && (this.m_MaxNum > -1 && this.m_Count < this.m_MaxNum || this.m_MaxNum == -1);
    }
}

