/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class Min
extends AbstractTransformer {
    private static final long serialVersionUID = 2007764064808349672L;
    protected boolean m_ReturnIndex;

    public String globalInfo() {
        return "Returns the minimum value from a double/int array or the index of the minimum value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "returnIndex", false);
    }

    public String getQuickInfo() {
        if (this.m_ReturnIndex) {
            return "Index";
        }
        return "Value";
    }

    public void setReturnIndex(boolean value) {
        this.m_ReturnIndex = value;
        this.reset();
    }

    public boolean getReturnIndex() {
        return this.m_ReturnIndex;
    }

    public String returnIndexTipText() {
        return "If set to true, then the index of the minimum is returned instead of the value.";
    }

    public Class[] accepts() {
        return new Class[]{Integer[].class, Double[].class};
    }

    public Class[] generates() {
        return new Class[]{Integer.class, Double.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() instanceof Double[]) {
                Number[] doubles = (Double[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.minIndex(doubles))) : new Token((Double)StatUtils.min(doubles));
            } else {
                Number[] integers = (Integer[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.minIndex(integers))) : new Token((Integer)StatUtils.min(integers));
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

