/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractDoubleClickableComponentWithButtons;
import adams.gui.core.BaseList;
import adams.gui.event.RemoveItemsListener;
import java.awt.event.MouseEvent;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseListWithButtons
extends AbstractDoubleClickableComponentWithButtons<BaseList> {
    private static final long serialVersionUID = 1935542795448084154L;
    protected ListDataListener m_CountModelListener;

    public BaseListWithButtons() {
    }

    public BaseListWithButtons(ListModel model) {
        ((BaseList)this.m_Component).setModel(model);
        this.updateCountsModelListener(model);
    }

    @Override
    public boolean requiresScrollPane() {
        return true;
    }

    @Override
    protected BaseList createComponent() {
        BaseList result = new BaseList();
        result.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BaseListWithButtons.this.updateCounts();
            }
        });
        return result;
    }

    @Override
    protected boolean isValidDoubleClick(MouseEvent e) {
        int index = ((BaseList)this.m_Component).locationToIndex(e.getPoint());
        return index > -1;
    }

    public void setModel(ListModel model) {
        this.updateCountsModelListener(model);
        ((BaseList)this.m_Component).setModel(model);
        this.updateCounts();
    }

    public ListModel getModel() {
        return ((BaseList)this.m_Component).getModel();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        ((BaseList)this.m_Component).addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        ((BaseList)this.m_Component).removeListSelectionListener(listener);
    }

    public int[] getSelectedIndices() {
        return ((BaseList)this.m_Component).getSelectedIndices();
    }

    public void setSelectedIndex(int index) {
        ((BaseList)this.m_Component).setSelectedIndex(index);
    }

    public void setSelectedIndices(int[] indices) {
        ((BaseList)this.m_Component).setSelectedIndices(indices);
    }

    public Object[] getSelectedValues() {
        return ((BaseList)this.m_Component).getSelectedValues();
    }

    public int getSelectedIndex() {
        return ((BaseList)this.m_Component).getSelectedIndex();
    }

    public Object getSelectedValue() {
        return ((BaseList)this.m_Component).getSelectedValue();
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        ((BaseList)this.m_Component).setSelectedValue(anObject, shouldScroll);
    }

    public void moveUp() {
        ((BaseList)this.m_Component).moveUp();
    }

    public void moveDown() {
        ((BaseList)this.m_Component).moveDown();
    }

    public void moveTop() {
        ((BaseList)this.m_Component).moveTop();
    }

    public void moveBottom() {
        ((BaseList)this.m_Component).moveBottom();
    }

    public boolean canMoveUp() {
        return ((BaseList)this.m_Component).canMoveUp();
    }

    public boolean canMoveDown() {
        return ((BaseList)this.m_Component).canMoveDown();
    }

    public void setSelectionMode(int selectionMode) {
        ((BaseList)this.m_Component).setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return ((BaseList)this.m_Component).getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return ((BaseList)this.m_Component).getSelectionModel();
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ((BaseList)this.m_Component).setSelectionModel(selectionModel);
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        ((BaseList)this.m_Component).addRemoveItemsListener(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        ((BaseList)this.m_Component).removeRemoveItemsListener(l);
    }

    @Override
    public void setInfoVisible(boolean value) {
        super.setInfoVisible(value);
        if (value) {
            this.updateCounts();
        }
    }

    protected void updateCountsModelListener(ListModel dataModel) {
        if (this.m_CountModelListener != null) {
            this.getModel().removeListDataListener(this.m_CountModelListener);
        }
        this.m_CountModelListener = new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
                BaseListWithButtons.this.updateCounts();
            }

            public void intervalAdded(ListDataEvent e) {
                BaseListWithButtons.this.updateCounts();
            }

            public void contentsChanged(ListDataEvent e) {
                BaseListWithButtons.this.updateCounts();
            }
        };
        dataModel.addListDataListener(this.m_CountModelListener);
    }

    protected void updateCounts() {
        this.updateInfo("Total: " + ((BaseList)this.m_Component).getModel().getSize() + ", Selected: " + ((BaseList)this.m_Component).getSelectedIndices().length);
    }
}

