/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.core.NumberTextField;
import adams.gui.goe.AbstractFloatingPointNumberEditor;

public class FloatEditor
extends AbstractFloatingPointNumberEditor {
    public FloatEditor() {
        this.m_CurrentValue = new Float(0.0f);
    }

    protected NumberTextField.Type getType() {
        return NumberTextField.Type.FLOAT;
    }

    public void setValue(Object value) {
        this.m_CurrentValue = new Float(((Number)value).floatValue());
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.m_CurrentValue;
    }

    protected Object parse(String text) throws IllegalArgumentException {
        Float result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = new Float(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }
}

