/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ConsoleObject;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class History
extends ConsoleObject {
    private static final long serialVersionUID = -1255734638729633595L;
    public static final int MAX_HISTORY_COUNT = 10;
    public static final int MAX_HISTORY_LENGTH = 200;
    protected Vector m_History = new Vector();

    public synchronized void add(Object obj) {
        if (this.m_History.contains(obj = Utils.deepCopy(obj))) {
            this.m_History.remove(obj);
        }
        this.m_History.insertElementAt(obj, 0);
        while (this.m_History.size() > 10) {
            this.m_History.remove(this.m_History.size() - 1);
        }
    }

    protected String generateMenuItemCaption(Object obj) {
        StringBuffer result = new StringBuffer();
        String cmd = OptionUtils.getCommandLine(obj);
        if (cmd.length() > 200) {
            cmd = cmd.substring(0, 200) + "...";
        }
        String[] lines = Utils.breakUp(cmd, 50);
        result.append("<html>");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            result.append(lines[i].trim());
        }
        result.append("</html>");
        return result.toString();
    }

    public void customizePopupMenu(JPopupMenu menu, Object current, HistorySelectionListener listener) {
        JMenu submenu = new JMenu("History");
        menu.add(submenu);
        JMenuItem item = new JMenuItem("Clear history");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                History.this.m_History.clear();
            }
        });
        submenu.add(item);
        final HistorySelectionListener fListener = listener;
        for (int i = 0; i < this.m_History.size(); ++i) {
            if (i == 0) {
                submenu.addSeparator();
            }
            final Object history = this.m_History.get(i);
            item = new JMenuItem(this.generateMenuItemCaption(history));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    fListener.historySelected(new HistorySelectionEvent(fListener, history));
                }
            });
            submenu.add(item);
        }
    }

    public static interface HistorySelectionListener {
        public void historySelected(HistorySelectionEvent var1);
    }

    public static class HistorySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 45824542929908105L;
        protected Object m_HistoryItem;

        public HistorySelectionEvent(Object source, Object historyItem) {
            super(source);
            this.m_HistoryItem = historyItem;
        }

        public Object getHistoryItem() {
            return this.m_HistoryItem;
        }
    }
}

