/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.globalactorstree;

import adams.gui.core.BaseTreeNode;
import adams.gui.goe.actorpathtree.ActorPathTree;
import adams.gui.goe.globalactorstree.GlobalActorsNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalActorsTree
extends ActorPathTree<GlobalActorsNode> {
    private static final long serialVersionUID = 1489354474021395304L;

    @Override
    protected GlobalActorsNode newNodeInstance(String label) {
        return new GlobalActorsNode(label);
    }

    public GlobalActorsNode findGlobalActor(String name) {
        BaseTreeNode node;
        GlobalActorsNode result = null;
        if (name != null && name.length() > 0 && (node = (BaseTreeNode)this.getTreeModel().getRoot()) != null) {
            Enumeration<TreeNode> enm = node.breadthFirstEnumeration();
            while (enm.hasMoreElements()) {
                GlobalActorsNode child;
                node = (BaseTreeNode)enm.nextElement();
                if (!(node instanceof GlobalActorsNode) || !(child = (GlobalActorsNode)node).isGlobalActor() || !child.getLabel().equals(name)) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    public void selectGlobalActor(String name) {
        GlobalActorsNode node = this.findGlobalActor(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
        }
    }
}

