/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.CleanUpHandler;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainerDisplayStringGenerator;
import adams.gui.visualization.container.AbstractContainerTableColumnNameGenerator;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DatabaseContainer;
import adams.gui.visualization.container.DatabaseContainerManager;
import adams.gui.visualization.container.DefaultContainerDisplayStringGenerator;
import adams.gui.visualization.container.DefaultContainerTableColumnNameGenerator;
import adams.gui.visualization.container.VisibilityContainerManager;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerModel<M extends ContainerManager, C extends Container>
extends AbstractBaseTableModel
implements DataChangeListener,
CleanUpHandler {
    private static final long serialVersionUID = -5056182487242887045L;
    protected M m_Manager;
    protected AbstractContainerDisplayStringGenerator m_Generator;
    protected AbstractContainerTableColumnNameGenerator m_ColumnNameGenerator;
    protected boolean m_DisplayVisibility;
    protected boolean m_DisplayDatabaseID;

    public ContainerModel() {
        this((ContainerManager)null);
    }

    public ContainerModel(ContainerListManager<M> manager) {
        this(manager == null ? (ContainerManager)null : manager.getContainerManager());
    }

    public ContainerModel(M manager) {
        this.m_Manager = manager;
        if (this.m_Manager != null) {
            ((ContainerManager)this.m_Manager).addDataChangeListener(this);
        }
        this.initialize();
    }

    protected void initialize() {
        this.m_DisplayVisibility = true;
        this.m_DisplayDatabaseID = false;
        this.m_Generator = new DefaultContainerDisplayStringGenerator();
        this.m_ColumnNameGenerator = new DefaultContainerTableColumnNameGenerator();
    }

    public M getManager() {
        return this.m_Manager;
    }

    public void unregister() {
        if (this.m_Manager != null) {
            ((ContainerManager)this.m_Manager).removeDataChangeListener(this);
        }
    }

    public void setDisplayStringGenerator(AbstractContainerDisplayStringGenerator value) {
        this.m_Generator = value;
        this.fireTableDataChanged();
    }

    public AbstractContainerDisplayStringGenerator getDisplayStringGenerator() {
        return this.m_Generator;
    }

    public void setColumnNameGenerator(AbstractContainerTableColumnNameGenerator value) {
        this.m_ColumnNameGenerator = value;
        this.fireTableStructureChanged();
    }

    public AbstractContainerTableColumnNameGenerator getColumnNameGenerator() {
        return this.m_ColumnNameGenerator;
    }

    public void setDisplayVisibility(boolean value) {
        this.m_DisplayVisibility = value;
        this.fireTableStructureChanged();
    }

    public boolean getDisplayVisibility() {
        return this.m_DisplayVisibility;
    }

    public void setDisplayDatabaseID(boolean value) {
        this.m_DisplayDatabaseID = value;
        this.fireTableStructureChanged();
    }

    public boolean getDisplayDatabaseID() {
        return this.m_DisplayDatabaseID;
    }

    protected boolean showVisibilityColumn() {
        return this.m_Manager instanceof VisibilityContainerManager && this.m_DisplayVisibility;
    }

    protected boolean showDatabaseIDColumn() {
        return this.m_Manager instanceof DatabaseContainerManager && this.m_DisplayDatabaseID;
    }

    @Override
    public int getColumnCount() {
        int result = 1;
        if (this.showVisibilityColumn()) {
            ++result;
        }
        if (this.showDatabaseIDColumn()) {
            ++result;
        }
        return result;
    }

    protected int getVisibilityColumn() {
        int result = -1;
        if (this.showVisibilityColumn()) {
            result = 0;
        }
        return result;
    }

    protected int getDatabaseIDColumn() {
        int result = -1;
        if (this.showDatabaseIDColumn()) {
            result = 0;
            if (this.showVisibilityColumn()) {
                ++result;
            }
        }
        return result;
    }

    protected int getDataColumn() {
        int result = 0;
        if (this.showDatabaseIDColumn()) {
            ++result;
        }
        if (this.showVisibilityColumn()) {
            ++result;
        }
        return result;
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex == this.getVisibilityColumn()) {
            return this.m_ColumnNameGenerator.getVisibilityWidth();
        }
        if (columnIndex == this.getDatabaseIDColumn()) {
            return this.m_ColumnNameGenerator.getDatabaseIDWidth();
        }
        if (columnIndex == this.getDataColumn()) {
            return this.m_ColumnNameGenerator.getDataWidth();
        }
        throw new IllegalStateException("Invalid column index: " + columnIndex);
    }

    @Override
    public int getRowCount() {
        if (this.m_Manager != null) {
            return ((ContainerManager)this.m_Manager).count();
        }
        return 0;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == this.getVisibilityColumn()) {
            return Boolean.class;
        }
        if (columnIndex == this.getDatabaseIDColumn()) {
            return Integer.class;
        }
        if (columnIndex == this.getDataColumn()) {
            return String.class;
        }
        throw new IllegalStateException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (column == this.getVisibilityColumn()) {
            return this.m_ColumnNameGenerator.getVisibility();
        }
        if (column == this.getDatabaseIDColumn()) {
            return this.m_ColumnNameGenerator.getDatabaseID();
        }
        if (column == this.getDataColumn()) {
            return this.m_ColumnNameGenerator.getData();
        }
        throw new IllegalStateException("Invalid column index: " + column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (((ContainerManager)this.m_Manager).isUpdating()) {
            return null;
        }
        if (rowIndex < ((ContainerManager)this.m_Manager).count()) {
            if (columnIndex == this.getVisibilityColumn()) {
                return new Boolean(((VisibilityContainerManager)this.getManager()).isVisible(rowIndex));
            }
            if (columnIndex == this.getDatabaseIDColumn()) {
                return new Integer(((DatabaseContainer)((ContainerManager)this.getManager()).get(rowIndex)).getDatabaseID());
            }
            if (columnIndex == this.getDataColumn()) {
                return this.m_Generator.getDisplay(((ContainerManager)this.getManager()).get(rowIndex));
            }
            throw new IllegalStateException("Invalid column index: " + columnIndex);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < ((ContainerManager)this.m_Manager).count() && this.showVisibilityColumn() && columnIndex == 0) {
            ((VisibilityContainerManager)this.getManager()).setVisible(rowIndex, (Boolean)aValue);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.showVisibilityColumn()) {
            return columnIndex == 0;
        }
        return false;
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        final int[] indices = e.getIndices();
        Runnable runnable = null;
        runnable = indices == null || indices.length == 0 ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableDataChanged();
            }
        } : (e.getType() == DataChangeEvent.Type.ADDITION ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableRowsInserted(indices[0], indices[indices.length - 1]);
            }
        } : (e.getType() == DataChangeEvent.Type.REMOVAL ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableRowsDeleted(indices[0], indices[0]);
            }
        } : (e.getType() == DataChangeEvent.Type.CLEAR ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableDataChanged();
            }
        } : (e.getType() == DataChangeEvent.Type.REPLACEMENT ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableRowsUpdated(indices[0], indices[0]);
            }
        } : (e.getType() == DataChangeEvent.Type.VISIBILITY ? new Runnable(){

            public void run() {
                ContainerModel.this.fireTableRowsUpdated(indices[0], indices[0]);
            }
        } : new Runnable(){

            public void run() {
                ContainerModel.this.fireTableDataChanged();
            }
        })))));
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public C getContainerAt(int row) {
        return (C)((ContainerManager)this.getManager()).get(row);
    }

    @Override
    public void cleanUp() {
        if (this.m_Manager != null) {
            ((ContainerManager)this.m_Manager).removeDataChangeListener(this);
        }
    }
}

