/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;

public class CoordinatesPaintlet
extends AbstractPaintlet {
    private static final long serialVersionUID = -3239338605889228940L;
    protected Color m_XColor;
    protected Color m_YColor;
    protected boolean m_XVisible;
    protected boolean m_YVisible;
    protected double m_XOffset;
    protected double m_YOffset;

    public String globalInfo() {
        return "Paintlet for painting the coordinates.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-x", "XColor", Color.GRAY);
        this.m_OptionManager.add("color-y", "YColor", Color.GRAY);
        this.m_OptionManager.add("invisible-x", "XInvisible", false);
        this.m_OptionManager.add("invisible-y", "YInvisible", false);
        this.m_OptionManager.add("offset-x", "XOffset", 0.0);
        this.m_OptionManager.add("offset-y", "YOffset", 0.0);
    }

    public void setXColor(Color value) {
        this.m_XColor = value;
        this.memberChanged();
    }

    public Color getXColor() {
        return this.m_XColor;
    }

    public String XColorTipText() {
        return "The color of the X axis.";
    }

    public void setYColor(Color value) {
        this.m_YColor = value;
        this.memberChanged();
    }

    public Color getYColor() {
        return this.m_YColor;
    }

    public String YColorTipText() {
        return "The color of the Y axis.";
    }

    public void setXOffset(double value) {
        this.m_XOffset = value;
        this.memberChanged();
    }

    public double getXOffset() {
        return this.m_XOffset;
    }

    public String XOffsetTipText() {
        return "The offset of the X axis.";
    }

    public void setYOffset(double value) {
        this.m_YOffset = value;
        this.memberChanged();
    }

    public double getYOffset() {
        return this.m_YOffset;
    }

    public String YOffsetTipText() {
        return "The offset of the Y axis.";
    }

    public void setXInvisible(boolean value) {
        this.m_XVisible = !value;
        this.memberChanged();
    }

    public boolean isXInvisible() {
        return !this.m_XVisible;
    }

    public String XInvisibleTipText() {
        return "If set to true then X axis is invisible.";
    }

    public void setYInvisible(boolean value) {
        this.m_YVisible = !value;
        this.memberChanged();
    }

    public boolean isYInvisible() {
        return !this.m_YVisible;
    }

    public String YInvisibleTipText() {
        return "If set to true then Y axis is invisible.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    public void performPaint(Graphics g) {
        if (this.m_XVisible) {
            AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
            g.setColor(this.m_XColor);
            g.drawLine(0, axisY.valueToPos(this.m_XOffset), this.getPlot().getWidth() - 1, axisY.valueToPos(this.m_XOffset));
        }
        if (this.m_YVisible) {
            AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            g.setColor(this.m_YColor);
            g.drawLine(axisX.valueToPos(this.m_YOffset), 0, axisX.valueToPos(this.m_YOffset), this.getPlot().getHeight() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Coordinates {
        X,
        Y;

    }
}

