/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceStickHitDetector;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class XYSequenceStickPaintlet
extends AbstractXYSequencePaintlet {
    private static final long serialVersionUID = 8242948176244747138L;
    protected boolean m_PaintAll;

    public String globalInfo() {
        return "Paintlet for painting a stick plot for a sequence.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("paint-all", "paintAll", false);
    }

    public boolean getPaintAll() {
        return this.m_PaintAll;
    }

    public void setPaintAll(boolean value) {
        this.m_PaintAll = value;
        this.memberChanged();
    }

    public String paintAllTipText() {
        return "If set to true, all data points will be painted, regardless whether they are visible or not.";
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new XYSequenceStickHitDetector(this.getSequencePanel());
    }

    protected void drawData(Graphics g, XYSequence data, Color color) {
        int end;
        int start;
        List<XYSequencePoint> points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        if (this.m_PaintAll) {
            start = 0;
            end = data.size() - 1;
        } else {
            start = XYSequenceUtils.findClosestX(points, Math.floor(axisX.getMinimum()));
            if (start > 0) {
                --start;
            }
            if ((end = XYSequenceUtils.findClosestX(points, Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
                ++end;
            }
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevX = axisX.valueToPos(((Number)points.get(start).getX()).doubleValue());
        for (int i = start; i <= end; ++i) {
            XYSequencePoint curr = points.get(i);
            currX = axisX.valueToPos(XYSequencePoint.toDouble(curr.getX()));
            if (!this.m_PaintAll && i != start && i != end && currX == prevX) continue;
            currY = axisY.valueToPos(XYSequencePoint.toDouble(curr.getY()));
            g.drawLine(currX, axisY.valueToPos(0.0), currX, currY);
            prevX = currX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g) {
        XYSequenceContainerManager xYSequenceContainerManager = (XYSequenceContainerManager)this.getSequencePanel().getContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).count(); ++i) {
                XYSequence data;
                if (!((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).isVisible(i) || (data = ((XYSequenceContainer)((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawData(g, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

