/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jmatharray;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import org.math.array.DoubleArray;
import org.math.array.LinearAlgebra;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMathArrayDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<double[][]> {
    private static final long serialVersionUID = -3223474248020842822L;
    private double[][] matrix = null;

    public JMathArrayDenseDoubleMatrix2D(long ... size) {
        this.matrix = new double[(int)size[0]][(int)size[1]];
    }

    public JMathArrayDenseDoubleMatrix2D(double[][] m) {
        this.matrix = m;
    }

    public JMathArrayDenseDoubleMatrix2D(org.ujmp.core.Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix[(int)row][(int)column];
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix[row][column];
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.length, this.matrix.length == 0 ? 0 : this.matrix[0].length};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix[(int)row][(int)column] = value;
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix[row][column] = value;
    }

    @Override
    public org.ujmp.core.Matrix[] svd() throws MatrixException {
        if (this.getColumnCount() > this.getRowCount()) {
            SingularValueDecomposition svd = new SingularValueDecomposition(new Matrix(DoubleArray.transpose((double[][])this.matrix)));
            JMathArrayDenseDoubleMatrix2D u = new JMathArrayDenseDoubleMatrix2D(svd.getV().getArray());
            JMathArrayDenseDoubleMatrix2D s = new JMathArrayDenseDoubleMatrix2D(svd.getS().transpose().getArray());
            JMathArrayDenseDoubleMatrix2D v = new JMathArrayDenseDoubleMatrix2D(svd.getU().getArray());
            return new org.ujmp.core.Matrix[]{u, s, v};
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(new Matrix(this.matrix));
        JMathArrayDenseDoubleMatrix2D u = new JMathArrayDenseDoubleMatrix2D(svd.getU().getArray());
        JMathArrayDenseDoubleMatrix2D s = new JMathArrayDenseDoubleMatrix2D(svd.getS().getArray());
        JMathArrayDenseDoubleMatrix2D v = new JMathArrayDenseDoubleMatrix2D(svd.getV().getArray());
        return new org.ujmp.core.Matrix[]{u, s, v};
    }

    @Override
    public org.ujmp.core.Matrix[] qr() {
        if (this.getRowCount() >= this.getColumnCount()) {
            QRDecomposition qr = new QRDecomposition(new Matrix(this.matrix));
            JMathArrayDenseDoubleMatrix2D q = new JMathArrayDenseDoubleMatrix2D(qr.getQ().getArray());
            JMathArrayDenseDoubleMatrix2D r = new JMathArrayDenseDoubleMatrix2D(qr.getR().getArray());
            return new org.ujmp.core.Matrix[]{q, r};
        }
        throw new MatrixException("QR decomposition only works for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix[] eig() {
        EigenvalueDecomposition eig = new EigenvalueDecomposition(new Matrix(this.matrix));
        JMathArrayDenseDoubleMatrix2D v = new JMathArrayDenseDoubleMatrix2D(eig.getV().getArray());
        JMathArrayDenseDoubleMatrix2D d = new JMathArrayDenseDoubleMatrix2D(eig.getD().getArray());
        return new org.ujmp.core.Matrix[]{v, d};
    }

    @Override
    public org.ujmp.core.Matrix chol() {
        CholeskyDecomposition chol = new CholeskyDecomposition(new Matrix(this.matrix));
        JMathArrayDenseDoubleMatrix2D r = new JMathArrayDenseDoubleMatrix2D(chol.getL().getArray());
        return r;
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        if (this.getRowCount() >= this.getColumnCount()) {
            LUDecomposition lu = new LUDecomposition(new Matrix(this.matrix));
            JMathArrayDenseDoubleMatrix2D l = new JMathArrayDenseDoubleMatrix2D(lu.getL().getArray());
            JMathArrayDenseDoubleMatrix2D u = new JMathArrayDenseDoubleMatrix2D(lu.getU().getArray());
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivot();
            JMathArrayDenseDoubleMatrix2D p = new JMathArrayDenseDoubleMatrix2D(m, m);
            int i = 0;
            while (i < m) {
                p.setAsDouble(1.0, new long[]{i, piv[i]});
                ++i;
            }
            return new org.ujmp.core.Matrix[]{l, u, p};
        }
        throw new MatrixException("LU decomposition only works for matrices m>=n");
    }

    @Override
    public double[][] getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(double[][] object) {
        this.matrix = object;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new JMathArrayDenseDoubleMatrix2D(DoubleArray.transpose((double[][])this.matrix));
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new JMathArrayDenseDoubleMatrix2D(LinearAlgebra.inverse((double[][])this.matrix));
    }

    @Override
    public org.ujmp.core.Matrix invSPD() {
        CholeskyDecomposition chol = new CholeskyDecomposition(new Matrix(this.matrix));
        return new JMathArrayDenseDoubleMatrix2D(chol.solve(Matrix.identity((int)this.matrix.length, (int)this.matrix.length)).getArray());
    }

    @Override
    public org.ujmp.core.Matrix plus(double value) {
        return new JMathArrayDenseDoubleMatrix2D(DoubleArray.add((double[][])DoubleArray.copy((double[][])this.matrix), (double)value));
    }

    @Override
    public org.ujmp.core.Matrix minus(double value) {
        return new JMathArrayDenseDoubleMatrix2D(DoubleArray.add((double[][])DoubleArray.copy((double[][])this.matrix), (double)(-value)));
    }

    @Override
    public org.ujmp.core.Matrix times(double value) {
        return new JMathArrayDenseDoubleMatrix2D(LinearAlgebra.times((double[][])this.matrix, (double)value));
    }

    @Override
    public org.ujmp.core.Matrix divide(double value) {
        return new JMathArrayDenseDoubleMatrix2D(LinearAlgebra.divide((double[][])this.matrix, (double)value));
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof JMathArrayDenseDoubleMatrix2D) {
            return new JMathArrayDenseDoubleMatrix2D(LinearAlgebra.times((double[][])this.matrix, (double[][])((JMathArrayDenseDoubleMatrix2D)m).matrix));
        }
        return super.mtimes(m);
    }

    @Override
    public org.ujmp.core.Matrix copy() {
        JMathArrayDenseDoubleMatrix2D m = new JMathArrayDenseDoubleMatrix2D(DoubleArray.copy((double[][])this.matrix));
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof JMathArrayDenseDoubleMatrix2D) {
            JMathArrayDenseDoubleMatrix2D b2 = (JMathArrayDenseDoubleMatrix2D)b;
            double[][] x = LinearAlgebra.solve((double[][])this.matrix, (double[][])b2.matrix);
            return new JMathArrayDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }
}

