/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import java.util.Arrays;
import moa.classifiers.AccuracyWeightedEnsemble;
import moa.classifiers.Classifier;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;
import weka.core.Instances;

public class AccuracyUpdatedEnsemble
extends AccuracyWeightedEnsemble {
    private static final long serialVersionUID = 1L;

    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        super.prepareForUseImpl(monitor, repository);
    }

    protected void processChunk() {
        Classifier addedClassifier = null;
        double candidateClassifierWeight = this.computeCandidateWeight(this.candidateClassifier, this.currentChunk, this.numFolds);
        for (int i = 0; i < this.storedLearners.length; ++i) {
            this.storedWeights[i][0] = this.computeWeight(this.storedLearners[(int)this.storedWeights[i][1]], this.currentChunk);
        }
        if (this.storedLearners.length < this.maxStoredCount) {
            this.trainOnChunk(this.candidateClassifier);
            addedClassifier = this.addToStored(this.candidateClassifier, candidateClassifierWeight);
        } else {
            Arrays.sort(this.storedWeights, weightComparator);
            if (this.storedWeights[0][0] < candidateClassifierWeight) {
                this.trainOnChunk(this.candidateClassifier);
                this.storedWeights[0][0] = candidateClassifierWeight;
                this.storedLearners[(int)this.storedWeights[0][1]] = addedClassifier = this.candidateClassifier.copy();
            }
        }
        int ensembleSize = Math.min(this.storedLearners.length, this.maxMemberCount);
        this.ensemble = new Classifier[ensembleSize];
        this.ensembleWeights = new double[ensembleSize];
        Arrays.sort(this.storedWeights, weightComparator);
        double mse_r = this.computeMseR();
        int storeSize = this.storedLearners.length;
        for (int i = 0; i < ensembleSize; ++i) {
            this.ensembleWeights[i] = this.storedWeights[storeSize - i - 1][0];
            this.ensemble[i] = this.storedLearners[(int)this.storedWeights[storeSize - i - 1][1]];
            if (this.ensemble[i] == addedClassifier || !(mse_r > 0.0) || !(this.ensembleWeights[i] > 1.0 / mse_r)) continue;
            this.trainOnChunk(this.ensemble[i]);
        }
        this.classDistributions = null;
        this.currentChunk = null;
        this.candidateClassifier = (Classifier)this.getPreparedClassOption(this.learnerOption);
        this.candidateClassifier.resetLearning();
    }

    protected double computeWeight(Classifier learner, Instances chunk) {
        double mse_i = 0.0;
        for (int i = 0; i < chunk.numInstances(); ++i) {
            try {
                double voteSum = 0.0;
                for (double element : learner.getVotesForInstance(chunk.instance(i))) {
                    voteSum += element;
                }
                if (voteSum > 0.0) {
                    double f_ci = learner.getVotesForInstance(chunk.instance(i))[(int)chunk.instance(i).classValue()] / voteSum;
                    mse_i += (1.0 - f_ci) * (1.0 - f_ci);
                    continue;
                }
                mse_i += 1.0;
                continue;
            }
            catch (Exception e) {
                mse_i += 1.0;
            }
        }
        if ((mse_i /= (double)this.chunkSize) > 0.0) {
            return 1.0 / mse_i;
        }
        return Double.MAX_VALUE;
    }

    private void trainOnChunk(Classifier classifierToTrain) {
        for (int num = 0; num < this.chunkSize; ++num) {
            classifierToTrain.trainOnInstance(this.currentChunk.instance(num));
        }
    }

    public boolean isRandomizable() {
        return false;
    }
}

