/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.DateFormat;
import adams.core.io.FileUtils;
import adams.core.io.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;

public class FileLog
extends Log {
    private static final long serialVersionUID = -1037691508623147214L;
    public static final String SUFFIX_FILEOUT = "Out";
    public static final String SUFFIX_FILEERR = "Err";
    public static final String SUFFIX_USETIMESTAMPS = "UseTimestamps";
    public static final String SUFFIX_TIMESTAMPFORMAT = "TimestampFormat";
    protected String m_FilenameOut;
    protected String m_FilenameErr;
    protected boolean m_UseTimestamps;
    protected boolean m_NewLineWritten;
    protected DateFormat m_TimestampFormat;

    protected void initialize() {
        super.initialize();
        this.m_FilenameOut = FileLog.getProperties().getString(this.getPropertyKey(SUFFIX_FILEOUT), "%p/log.out");
        this.m_FilenameErr = FileLog.getProperties().getString(this.getPropertyKey(SUFFIX_FILEERR), "%p/log.err");
        this.m_UseTimestamps = FileLog.getProperties().getBoolean(this.getPropertyKey(SUFFIX_USETIMESTAMPS), false);
        this.m_TimestampFormat = new DateFormat(FileLog.getProperties().getString(this.getPropertyKey(SUFFIX_TIMESTAMPFORMAT), "yyyy-MM-dd HH:mm:ss"));
        FileUtils.delete(this.m_FilenameOut);
        FileUtils.delete(this.m_FilenameErr);
        this.m_NewLineWritten = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doLog(String msg, boolean out, boolean newline) {
        BufferedWriter writer = null;
        try {
            writer = out ? new BufferedWriter(new FileWriter(this.m_FilenameOut, true)) : new BufferedWriter(new FileWriter(this.m_FilenameErr, true));
            if ((newline || !newline && this.m_NewLineWritten) && this.m_UseTimestamps) {
                writer.write(this.m_TimestampFormat.format(new Date()) + "\t");
            }
            writer.write(msg);
            this.m_NewLineWritten = newline;
            if (newline) {
                writer.newLine();
            }
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

