/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractFormattedSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import java.io.Writer;
import java.util.Enumeration;

public class LatexSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter {
    private static final long serialVersionUID = 8693302523602090616L;

    public String globalInfo() {
        return "Generates LaTeX tables from spreadsheets.";
    }

    public String getFormatDescription() {
        return "LaTeX table output";
    }

    public String[] getFormatExtensions() {
        return new String[]{"tex"};
    }

    protected boolean getUseOutputStream() {
        return false;
    }

    protected String escape(String s) {
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '_': 
                case '{': 
                case '}': {
                    result.append('\\');
                    result.append(c);
                    continue block4;
                }
                case '<': 
                case '>': {
                    result.append('$');
                    result.append(c);
                    result.append('$');
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            SpreadSheet.Cell cell;
            int i;
            String newline = System.getProperty("line.separator");
            for (i = 0; i < content.getComments().size(); ++i) {
                writer.write("% " + content.getComments().get(i) + newline);
            }
            writer.write("\\begin{tabular}{|");
            for (i = 0; i < content.getColumnCount(); ++i) {
                if (content.isNumeric(i)) {
                    writer.write("r|");
                    continue;
                }
                writer.write("l|");
            }
            writer.write("}" + newline);
            writer.write("  \\hline" + newline);
            Enumeration<String> cellKeys = content.getHeaderRow().cellKeys();
            boolean first = true;
            while (cellKeys.hasMoreElements()) {
                cell = content.getHeaderRow().getCell(cellKeys.nextElement());
                if (!first) {
                    writer.write(" & ");
                } else {
                    writer.write("  ");
                }
                if (cell.isMissing()) {
                    writer.write(this.escape(this.m_MissingValue));
                } else {
                    writer.write(this.escape(cell.getContent()));
                }
                first = false;
            }
            writer.write(" \\\\" + newline);
            Enumeration<String> rowKeys = content.rowKeys();
            while (rowKeys.hasMoreElements()) {
                writer.write("  \\hline" + newline);
                SpreadSheet.Row row = content.getRow(rowKeys.nextElement());
                cellKeys = content.getHeaderRow().cellKeys();
                first = true;
                while (cellKeys.hasMoreElements()) {
                    cell = row.getCell(cellKeys.nextElement());
                    if (!first) {
                        writer.write(" & ");
                    } else {
                        writer.write("  ");
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        if (cell.isNumeric()) {
                            writer.write(this.escape(this.format(cell.toDouble())));
                        } else {
                            writer.write(this.escape(cell.getContent()));
                        }
                    } else {
                        writer.write(this.escape(this.m_MissingValue));
                    }
                    first = false;
                }
                writer.write(" \\\\" + newline);
            }
            writer.write("  \\hline" + newline);
            writer.write("\\end{tabular}" + newline);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

