/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Properties;
import adams.env.Environment;
import java.util.Enumeration;
import java.util.Hashtable;

public class Conversion {
    private static final long serialVersionUID = -3353633915381285876L;
    public static final String FILENAME = "Conversion.props";
    public static final String KEY_RENAME = "Rename";
    public static final String KEY_PARTIAL_RENAME = "PartialRename";
    protected static Properties m_Properties;
    protected static Hashtable<String, String> m_Mapping;
    protected static Hashtable<String, String> m_MappingPartial;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("conversion");
        }
        return m_Properties;
    }

    protected static synchronized void initMappings() {
        if (m_Mapping == null) {
            String[] parts;
            int i;
            Properties props = Conversion.getProperties();
            String[] keys = props.getString(KEY_RENAME, "").split(",");
            m_Mapping = new Hashtable();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Rename mapping '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getString(keys[i], "").split("-");
                    if (parts.length != 2) {
                        System.err.println("Wrong format for rename mapping ('" + keys[i] + "'): " + props.getString(keys[i]));
                        continue;
                    }
                    m_Mapping.put(parts[0], parts[1]);
                }
            }
            keys = props.getString(KEY_PARTIAL_RENAME, "").split(",");
            m_MappingPartial = new Hashtable();
            if (keys.length >= 1 && keys[0].length() != 0) {
                for (i = 0; i < keys.length; ++i) {
                    if (!props.hasKey(keys[i])) {
                        System.err.println("Partial renaming '" + keys[i] + "' not found - skipped!");
                        continue;
                    }
                    parts = props.getString(keys[i], "").split("\t");
                    if (parts.length != 2) {
                        System.err.println("Wrong format for partial renaming ('" + keys[i] + "'): " + props.getString(keys[i]));
                        continue;
                    }
                    m_MappingPartial.put(parts[0], parts[1]);
                }
            }
        }
    }

    public static synchronized String rename(String classname) {
        String result = classname;
        Conversion.initMappings();
        while (m_Mapping.containsKey(result)) {
            result = m_Mapping.get(result);
        }
        Enumeration<String> keys = m_MappingPartial.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result = result.replace(key, m_MappingPartial.get(key));
        }
        return result;
    }
}

