/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.net.HtmlUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.EnumOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParametersProducer
extends AbstractOptionProducer<String, StringBuilder>
implements FileBasedProducer {
    private static final long serialVersionUID = 7520567844837662391L;
    protected StringBuilder m_OutputBuffer;

    @Override
    public String globalInfo() {
        return "Generates HTML 3 help output, which is used in the GUI.";
    }

    @Override
    protected String initOutput() {
        return "";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_OutputBuffer = new StringBuilder();
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputBuffer.toString();
        }
        return (String)this.m_Output;
    }

    protected String toHTML(String s) {
        return this.toHTML(s, false);
    }

    protected String toHTML(String s, boolean nbsp) {
        return HtmlUtils.toHTML(s, nbsp);
    }

    protected void addToolTip(AbstractOption option, StringBuilder buffer) {
        if (option.getToolTipMethod() != null) {
            try {
                String text = (String)option.getToolTipMethod().invoke((Object)option.getOptionHandler(), new Object[0]);
                buffer.append("<p>");
                buffer.append(this.toHTML(text));
                buffer.append("</p>\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addArgumentInfo(AbstractArgumentOption option, StringBuilder buffer) {
        String text;
        if (option instanceof EnumOption) {
            text = "";
            try {
                Method method = option.getBaseClass().getMethod("values", new Class[0]);
                Object[] vals = (Object[])method.invoke(null, new Object[0]);
                text = Utils.arrayToString(vals).replaceAll(",", "|");
            }
            catch (Exception e) {
                e.printStackTrace();
                text = "Error retrieving enum values";
            }
        } else {
            text = option.getBaseClass().getName();
        }
        buffer.append(" &lt;" + this.toHTML(text) + "&gt;");
    }

    @Override
    public StringBuilder processOption(BooleanOption option) {
        StringBuilder result = new StringBuilder();
        Boolean value = (Boolean)option.getCurrentValue();
        if (value.booleanValue() != ((Boolean)option.getDefaultValue()).booleanValue()) {
            result.append("<li>\n");
            result.append("<b>" + this.toHTML(option.getProperty()) + "</b>\n");
            result.append("<br>\n");
            if (value.booleanValue()) {
                result.append("enabled");
            } else {
                result.append("disabled");
            }
            result.append("<br>\n");
            result.append("</li>\n");
            this.m_OutputBuffer.append((CharSequence)result);
        }
        return result;
    }

    @Override
    public StringBuilder processOption(ClassOption option) {
        return this.processOption((AbstractArgumentOption)option);
    }

    @Override
    public StringBuilder processOption(AbstractArgumentOption option) {
        StringBuilder result = new StringBuilder();
        Object value = option.getCurrentValue();
        if (!option.isDefaultValue(value)) {
            String text;
            result.append("<li>\n");
            result.append("<b>" + this.toHTML(option.getProperty()) + "</b>\n");
            result.append("<br>\n");
            if (value == null) {
                text = "null";
            } else if (option.isMultiple()) {
                text = "";
                for (int n = 0; n < Array.getLength(value); ++n) {
                    if (n > 0) {
                        text = text + ", ";
                    }
                    text = text + option.toString(Array.get(value, n));
                }
            } else {
                text = option.toString(value);
            }
            result.append(this.toHTML(Utils.backQuoteChars(text)) + "\n");
            result.append("<br>\n");
            result.append("</li>\n");
            this.m_OutputBuffer.append((CharSequence)result);
        }
        return result;
    }

    @Override
    protected void preProduce(OptionManager manager, int index) {
        super.preProduce(manager, index);
        this.m_Output = null;
    }

    @Override
    protected void preProduce() {
        this.m_OutputBuffer = new StringBuilder();
        this.m_OutputBuffer.append("<html>\n");
        this.m_OutputBuffer.append("<head>\n");
        this.m_OutputBuffer.append("<title>" + this.getInput().getClass().getName() + "<title>\n");
        this.m_OutputBuffer.append("</head>\n");
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append("<body>\n");
        this.m_OutputBuffer.append("<h3>Name</h3>\n");
        this.m_OutputBuffer.append("<p><code>" + this.getInput().getClass().getName() + "</code></p>\n");
        this.m_OutputBuffer.append("<br>\n");
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append("<h3>Parameters</h3>\n");
        this.m_OutputBuffer.append("<ul>\n");
    }

    @Override
    protected void postProduce() {
        this.m_OutputBuffer.append("</ul>\n");
        this.m_OutputBuffer.append("</body>\n");
        this.m_OutputBuffer.append("</html>\n");
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    @Override
    public String getFileFormat() {
        return "HTML Parameters";
    }

    @Override
    public String getDefaultFileExtension() {
        return "html";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{"html", "htm"};
    }
}

