/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEquiDistance<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = -2590871295104049256L;
    protected int m_NumPoints;
    protected boolean m_AllowOversampling;
    protected int m_Offset;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", -1, -1, null);
        this.m_OptionManager.add("offset", "offset", -1, -1, null);
        this.m_OptionManager.add("allow-oversampling", "allowOversampling", false);
    }

    public void setNumPoints(int value) {
        if (value > 0 || value == -1) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": only '-1' (uses the number of points " + "currently in the data) or positive numbers are allowed!");
        }
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to generate, '-1' will use the same amount of points as currently in the input data.";
    }

    public void setAllowOversampling(boolean value) {
        this.m_AllowOversampling = value;
        this.reset();
    }

    public boolean getAllowOversampling() {
        return this.m_AllowOversampling;
    }

    public String allowOversamplingTipText() {
        return "If set to true, then over-sampling is allowed, ie, generating more data points than in the original data.";
    }

    public void setOffset(int off) {
        this.m_Offset = off;
        this.reset();
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public abstract String offsetTipText();
}

