/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.data.report.AbstractReportFilter;
import adams.data.report.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFilter<T extends DataContainer>
extends AbstractDatabaseConnectionFilter<T> {
    private static final long serialVersionUID = -754895778604425899L;
    protected AbstractReportFilter<T> m_Filter;

    @Override
    public String globalInfo() {
        return "A filter that modifies the reports of data containers being passed through. The supplied report filter updates/modifies the report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setFilter(AbstractReportFilter value) {
        this.m_Filter = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractReportFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for updating/modifying the report.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_Filter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Filter)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        DataContainer result = this.m_Filter.filter((DataContainer)data.getClone());
        this.m_Filter.cleanUp();
        return (T)result;
    }
}

